/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestructionAwareAttributeHolder
implements Serializable {
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private Map<String, Runnable> registeredDestructionCallbacks;

    public Map<String, Object> getAttributeMap() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object setAttribute(String name, Object value2) {
        return this.attributes.put(name, value2);
    }

    public Object removeAttribute(String name) {
        Object value2 = this.attributes.remove(name);
        Runnable callback = this.getDestructionCallback(name, true);
        if (callback != null) {
            callback.run();
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DestructionAwareAttributeHolder destructionAwareAttributeHolder = this;
        synchronized (destructionAwareAttributeHolder) {
            if (this.registeredDestructionCallbacks != null) {
                for (Runnable runnable : this.registeredDestructionCallbacks.values()) {
                    runnable.run();
                }
                this.registeredDestructionCallbacks.clear();
            }
        }
        this.attributes.clear();
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        if (this.registeredDestructionCallbacks == null) {
            this.registeredDestructionCallbacks = new ConcurrentHashMap<String, Runnable>();
        }
        this.registeredDestructionCallbacks.put(name, callback);
    }

    public Runnable getDestructionCallback(String name, boolean remove2) {
        if (this.registeredDestructionCallbacks == null) {
            return null;
        }
        if (remove2) {
            return this.registeredDestructionCallbacks.remove(name);
        }
        return this.registeredDestructionCallbacks.get(name);
    }
}

