/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.InvocationTargetException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvokingFactoryBean
extends ArgumentConvertingMethodInvoker
implements FactoryBean<Object>,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean {
    private boolean singleton = true;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private ConfigurableBeanFactory beanFactory;
    private boolean initialized = false;
    private Object singletonObject;

    public void setSingleton(boolean singleton2) {
        this.singleton = singleton2;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    protected Class resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, this.beanClassLoader);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    @Override
    protected TypeConverter getDefaultTypeConverter() {
        if (this.beanFactory != null) {
            return this.beanFactory.getTypeConverter();
        }
        return super.getDefaultTypeConverter();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.prepare();
        if (this.singleton) {
            this.initialized = true;
            this.singletonObject = this.doInvoke();
        }
    }

    private Object doInvoke() throws Exception {
        try {
            return this.invoke();
        }
        catch (InvocationTargetException ex2) {
            if (ex2.getTargetException() instanceof Exception) {
                throw (Exception)ex2.getTargetException();
            }
            if (ex2.getTargetException() instanceof Error) {
                throw (Error)ex2.getTargetException();
            }
            throw ex2;
        }
    }

    @Override
    public Object getObject() throws Exception {
        if (this.singleton) {
            if (!this.initialized) {
                throw new FactoryBeanNotInitializedException();
            }
            return this.singletonObject;
        }
        return this.doInvoke();
    }

    @Override
    public Class<?> getObjectType() {
        if (!this.isPrepared()) {
            return null;
        }
        return this.getPreparedMethod().getReturnType();
    }
}

