/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocatorFactoryBean
implements FactoryBean<Object>,
BeanFactoryAware,
InitializingBean {
    private Class serviceLocatorInterface;
    private Constructor serviceLocatorExceptionConstructor;
    private Properties serviceMappings;
    private ListableBeanFactory beanFactory;
    private Object proxy;

    public void setServiceLocatorInterface(Class interfaceType) {
        this.serviceLocatorInterface = interfaceType;
    }

    public void setServiceLocatorExceptionClass(Class serviceLocatorExceptionClass) {
        if (serviceLocatorExceptionClass != null && !Exception.class.isAssignableFrom(serviceLocatorExceptionClass)) {
            throw new IllegalArgumentException("serviceLocatorException [" + serviceLocatorExceptionClass.getName() + "] is not a subclass of Exception");
        }
        this.serviceLocatorExceptionConstructor = this.determineServiceLocatorExceptionConstructor(serviceLocatorExceptionClass);
    }

    public void setServiceMappings(Properties serviceMappings) {
        this.serviceMappings = serviceMappings;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new FatalBeanException("ServiceLocatorFactoryBean needs to run in a BeanFactory that is a ListableBeanFactory");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.serviceLocatorInterface == null) {
            throw new IllegalArgumentException("Property 'serviceLocatorInterface' is required");
        }
        this.proxy = Proxy.newProxyInstance(this.serviceLocatorInterface.getClassLoader(), new Class[]{this.serviceLocatorInterface}, (InvocationHandler)new ServiceLocatorInvocationHandler());
    }

    protected Constructor determineServiceLocatorExceptionConstructor(Class exceptionClass) {
        try {
            return exceptionClass.getConstructor(String.class, Throwable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return exceptionClass.getConstructor(Throwable.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    return exceptionClass.getConstructor(String.class);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    throw new IllegalArgumentException("Service locator exception [" + exceptionClass.getName() + "] neither has a (String, Throwable) constructor nor a (String) constructor");
                }
            }
        }
    }

    protected Exception createServiceLocatorException(Constructor exceptionConstructor, BeansException cause) {
        Class<?>[] paramTypes2 = exceptionConstructor.getParameterTypes();
        Object[] args2 = new Object[paramTypes2.length];
        int i = 0;
        while (i < paramTypes2.length) {
            if (paramTypes2[i].equals(String.class)) {
                args2[i] = cause.getMessage();
            } else if (paramTypes2[i].isInstance(cause)) {
                args2[i] = cause;
            }
            ++i;
        }
        return (Exception)BeanUtils.instantiateClass(exceptionConstructor, args2);
    }

    @Override
    public Object getObject() {
        return this.proxy;
    }

    @Override
    public Class<?> getObjectType() {
        return this.serviceLocatorInterface;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    private class ServiceLocatorInvocationHandler
    implements InvocationHandler {
        private ServiceLocatorInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if (ReflectionUtils.isEqualsMethod(method)) {
                if (proxy == args2[0]) {
                    return true;
                }
                return false;
            }
            if (ReflectionUtils.isHashCodeMethod(method)) {
                return System.identityHashCode(proxy);
            }
            if (ReflectionUtils.isToStringMethod(method)) {
                return "Service locator: " + ServiceLocatorFactoryBean.this.serviceLocatorInterface.getName();
            }
            return this.invokeServiceLocatorMethod(method, args2);
        }

        private Object invokeServiceLocatorMethod(Method method, Object[] args2) throws Exception {
            Class serviceLocatorMethodReturnType = this.getServiceLocatorMethodReturnType(method);
            try {
                String beanName = this.tryGetBeanName(args2);
                if (StringUtils.hasLength(beanName)) {
                    return ServiceLocatorFactoryBean.this.beanFactory.getBean(beanName, serviceLocatorMethodReturnType);
                }
                return BeanFactoryUtils.beanOfTypeIncludingAncestors(ServiceLocatorFactoryBean.this.beanFactory, serviceLocatorMethodReturnType);
            }
            catch (BeansException ex2) {
                if (ServiceLocatorFactoryBean.this.serviceLocatorExceptionConstructor != null) {
                    throw ServiceLocatorFactoryBean.this.createServiceLocatorException(ServiceLocatorFactoryBean.this.serviceLocatorExceptionConstructor, ex2);
                }
                throw ex2;
            }
        }

        private String tryGetBeanName(Object[] args2) {
            String mappedName;
            String beanName = "";
            if (args2 != null && args2.length == 1 && args2[0] != null) {
                beanName = args2[0].toString();
            }
            if (ServiceLocatorFactoryBean.this.serviceMappings != null && (mappedName = ServiceLocatorFactoryBean.this.serviceMappings.getProperty(beanName)) != null) {
                beanName = mappedName;
            }
            return beanName;
        }

        private Class getServiceLocatorMethodReturnType(Method method) throws NoSuchMethodException {
            Class<?>[] paramTypes2 = method.getParameterTypes();
            Method interfaceMethod = ServiceLocatorFactoryBean.this.serviceLocatorInterface.getMethod(method.getName(), paramTypes2);
            Class<?> serviceLocatorReturnType = interfaceMethod.getReturnType();
            if (paramTypes2.length > 1 || Void.TYPE.equals(serviceLocatorReturnType)) {
                throw new UnsupportedOperationException("May only call methods with signature '<type> xxx()' or '<type> xxx(<idtype> id)' on factory interface, but tried to call: " + interfaceMethod);
            }
            return serviceLocatorReturnType;
        }
    }
}

