/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    public static final String TRUE_VALUE = "true";
    public static final String SEPARATOR = ".";
    public static final String CLASS_KEY = "(class)";
    public static final String PARENT_KEY = "(parent)";
    public static final String SCOPE_KEY = "(scope)";
    public static final String SINGLETON_KEY = "(singleton)";
    public static final String ABSTRACT_KEY = "(abstract)";
    public static final String LAZY_INIT_KEY = "(lazy-init)";
    public static final String REF_SUFFIX = "(ref)";
    public static final String REF_PREFIX = "*";
    public static final String CONSTRUCTOR_ARG_PREFIX = "$";
    private String defaultParentBean;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();

    public PropertiesBeanDefinitionReader(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public void setDefaultParentBean(String defaultParentBean) {
        this.defaultParentBean = defaultParentBean;
    }

    public String getDefaultParentBean() {
        return this.defaultParentBean;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    public PropertiesPersister getPropertiesPersister() {
        return this.propertiesPersister;
    }

    @Override
    public int loadBeanDefinitions(Resource resource) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(new EncodedResource(resource), null);
    }

    public int loadBeanDefinitions(Resource resource, String prefix2) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(new EncodedResource(resource), prefix2);
    }

    public int loadBeanDefinitions(EncodedResource encodedResource) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(encodedResource, null);
    }

    public int loadBeanDefinitions(EncodedResource encodedResource, String prefix2) throws BeanDefinitionStoreException {
        Properties props = new Properties();
        try {
            InputStream is2 = encodedResource.getResource().getInputStream();
            try {
                if (encodedResource.getEncoding() != null) {
                    this.getPropertiesPersister().load(props, new InputStreamReader(is2, encodedResource.getEncoding()));
                } else {
                    this.getPropertiesPersister().load(props, is2);
                }
            }
            finally {
                is2.close();
            }
            return this.registerBeanDefinitions(props, prefix2, encodedResource.getResource().getDescription());
        }
        catch (IOException ex2) {
            throw new BeanDefinitionStoreException("Could not parse properties from " + encodedResource.getResource(), ex2);
        }
    }

    public int registerBeanDefinitions(ResourceBundle rb) throws BeanDefinitionStoreException {
        return this.registerBeanDefinitions(rb, null);
    }

    public int registerBeanDefinitions(ResourceBundle rb, String prefix2) throws BeanDefinitionStoreException {
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        Enumeration<String> keys2 = rb.getKeys();
        while (keys2.hasMoreElements()) {
            String key = keys2.nextElement();
            map3.put(key, rb.getObject(key));
        }
        return this.registerBeanDefinitions(map3, prefix2);
    }

    public int registerBeanDefinitions(Map map3) throws BeansException {
        return this.registerBeanDefinitions(map3, null);
    }

    public int registerBeanDefinitions(Map map3, String prefix2) throws BeansException {
        return this.registerBeanDefinitions(map3, prefix2, "Map " + map3);
    }

    public int registerBeanDefinitions(Map map3, String prefix2, String resourceDescription) throws BeansException {
        if (prefix2 == null) {
            prefix2 = "";
        }
        int beanCount = 0;
        for (Object key : map3.keySet()) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Illegal key [" + key + "]: only Strings allowed");
            }
            String keyString = (String)key;
            if (!keyString.startsWith(prefix2)) continue;
            String nameAndProperty = keyString.substring(prefix2.length());
            int sepIdx = -1;
            int propKeyIdx = nameAndProperty.indexOf("[");
            sepIdx = propKeyIdx != -1 ? nameAndProperty.lastIndexOf(SEPARATOR, propKeyIdx) : nameAndProperty.lastIndexOf(SEPARATOR);
            if (sepIdx != -1) {
                String beanName = nameAndProperty.substring(0, sepIdx);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found bean name '" + beanName + "'");
                }
                if (this.getRegistry().containsBeanDefinition(beanName)) continue;
                this.registerBeanDefinition(beanName, map3, String.valueOf(prefix2) + beanName, resourceDescription);
                ++beanCount;
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Invalid bean name and property [" + nameAndProperty + "]");
        }
        return beanCount;
    }

    protected void registerBeanDefinition(String beanName, Map<?, ?> map3, String prefix2, String resourceDescription) throws BeansException {
        String className = null;
        String parent2 = null;
        String scope = "singleton";
        boolean isAbstract = false;
        boolean lazyInit = false;
        ConstructorArgumentValues cas = new ConstructorArgumentValues();
        MutablePropertyValues pvs = new MutablePropertyValues();
        for (Map.Entry<?, ?> entry2 : map3.entrySet()) {
            String key = StringUtils.trimWhitespace((String)entry2.getKey());
            if (!key.startsWith(String.valueOf(prefix2) + SEPARATOR)) continue;
            String property = key.substring(prefix2.length() + SEPARATOR.length());
            if (CLASS_KEY.equals(property)) {
                className = StringUtils.trimWhitespace((String)entry2.getValue());
                continue;
            }
            if (PARENT_KEY.equals(property)) {
                parent2 = StringUtils.trimWhitespace((String)entry2.getValue());
                continue;
            }
            if (ABSTRACT_KEY.equals(property)) {
                String val = StringUtils.trimWhitespace((String)entry2.getValue());
                isAbstract = TRUE_VALUE.equals(val);
                continue;
            }
            if (SCOPE_KEY.equals(property)) {
                scope = StringUtils.trimWhitespace((String)entry2.getValue());
                continue;
            }
            if (SINGLETON_KEY.equals(property)) {
                String val = StringUtils.trimWhitespace((String)entry2.getValue());
                scope = val == null || TRUE_VALUE.equals(val) ? "singleton" : "prototype";
                continue;
            }
            if (LAZY_INIT_KEY.equals(property)) {
                String val = StringUtils.trimWhitespace((String)entry2.getValue());
                lazyInit = TRUE_VALUE.equals(val);
                continue;
            }
            if (property.startsWith(CONSTRUCTOR_ARG_PREFIX)) {
                if (property.endsWith(REF_SUFFIX)) {
                    int index2 = Integer.parseInt(property.substring(1, property.length() - REF_SUFFIX.length()));
                    cas.addIndexedArgumentValue(index2, new RuntimeBeanReference(entry2.getValue().toString()));
                    continue;
                }
                int index3 = Integer.parseInt(property.substring(1));
                cas.addIndexedArgumentValue(index3, this.readValue(entry2));
                continue;
            }
            if (property.endsWith(REF_SUFFIX)) {
                property = property.substring(0, property.length() - REF_SUFFIX.length());
                String ref = StringUtils.trimWhitespace((String)entry2.getValue());
                RuntimeBeanReference val = new RuntimeBeanReference(ref);
                pvs.add(property, val);
                continue;
            }
            pvs.add(property, this.readValue(entry2));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering bean definition for bean name '" + beanName + "' with " + pvs);
        }
        if (parent2 == null && className == null && !beanName.equals(this.defaultParentBean)) {
            parent2 = this.defaultParentBean;
        }
        try {
            AbstractBeanDefinition bd = BeanDefinitionReaderUtils.createBeanDefinition(parent2, className, this.getBeanClassLoader());
            bd.setScope(scope);
            bd.setAbstract(isAbstract);
            bd.setLazyInit(lazyInit);
            bd.setConstructorArgumentValues(cas);
            bd.setPropertyValues(pvs);
            this.getRegistry().registerBeanDefinition(beanName, bd);
        }
        catch (ClassNotFoundException ex2) {
            throw new CannotLoadBeanClassException(resourceDescription, beanName, className, ex2);
        }
        catch (LinkageError err2) {
            throw new CannotLoadBeanClassException(resourceDescription, beanName, className, err2);
        }
    }

    private Object readValue(Map.Entry entry2) {
        String strVal;
        Object val = entry2.getValue();
        if (val instanceof String && (strVal = (String)val).startsWith(REF_PREFIX)) {
            String targetName = strVal.substring(1);
            val = targetName.startsWith(REF_PREFIX) ? targetName : new RuntimeBeanReference(targetName);
        }
        return val;
    }
}

