/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ReplaceOverride
extends MethodOverride {
    private final String methodReplacerBeanName;
    private List<String> typeIdentifiers = new LinkedList<String>();

    public ReplaceOverride(String methodName, String methodReplacerBeanName) {
        super(methodName);
        Assert.notNull(methodName, "Method replacer bean name must not be null");
        this.methodReplacerBeanName = methodReplacerBeanName;
    }

    public String getMethodReplacerBeanName() {
        return this.methodReplacerBeanName;
    }

    public void addTypeIdentifier(String identifier2) {
        this.typeIdentifiers.add(identifier2);
    }

    public boolean matches(Method method) {
        if (!method.getName().equals(this.getMethodName())) {
            return false;
        }
        if (!this.isOverloaded()) {
            return true;
        }
        if (this.typeIdentifiers.size() != method.getParameterTypes().length) {
            return false;
        }
        int i = 0;
        while (i < this.typeIdentifiers.size()) {
            String identifier2 = this.typeIdentifiers.get(i);
            if (!method.getParameterTypes()[i].getName().contains(identifier2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return "Replace override for method '" + this.getMethodName() + "; will call bean '" + this.methodReplacerBeanName + "'";
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReplaceOverride) || !super.equals(other)) {
            return false;
        }
        ReplaceOverride that = (ReplaceOverride)other;
        return ObjectUtils.nullSafeEquals(this.methodReplacerBeanName, that.methodReplacerBeanName) && ObjectUtils.nullSafeEquals(this.typeIdentifiers, that.typeIdentifiers);
    }

    public int hashCode() {
        int hashCode2 = super.hashCode();
        hashCode2 = 29 * hashCode2 + ObjectUtils.nullSafeHashCode(this.methodReplacerBeanName);
        hashCode2 = 29 * hashCode2 + ObjectUtils.nullSafeHashCode(this.typeIdentifiers);
        return hashCode2;
    }
}

