/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInstantiationStrategy
implements InstantiationStrategy {
    private static final ThreadLocal<Method> currentlyInvokedFactoryMethod = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        if (beanDefinition.getMethodOverrides().isEmpty()) {
            Constructor constructorToUse;
            Object object = beanDefinition.constructorArgumentLock;
            synchronized (object) {
                constructorToUse = (Constructor)beanDefinition.resolvedConstructorOrFactoryMethod;
                if (constructorToUse == null) {
                    final Class<?> clazz2 = beanDefinition.getBeanClass();
                    if (clazz2.isInterface()) {
                        throw new BeanInstantiationException(clazz2, "Specified class is an interface");
                    }
                    try {
                        constructorToUse = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor>(){

                            @Override
                            public Constructor run() throws Exception {
                                return clazz2.getDeclaredConstructor(null);
                            }
                        }) : clazz2.getDeclaredConstructor(null);
                        beanDefinition.resolvedConstructorOrFactoryMethod = constructorToUse;
                    }
                    catch (Exception ex2) {
                        throw new BeanInstantiationException(clazz2, "No default constructor found", ex2);
                    }
                }
            }
            return BeanUtils.instantiateClass(constructorToUse, new Object[0]);
        }
        return this.instantiateWithMethodInjection(beanDefinition, beanName, owner);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    @Override
    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, final Constructor<?> ctor, Object[] args2) {
        if (beanDefinition.getMethodOverrides().isEmpty()) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ReflectionUtils.makeAccessible(ctor);
                        return null;
                    }
                });
            }
            return BeanUtils.instantiateClass(ctor, args2);
        }
        return this.instantiateWithMethodInjection(beanDefinition, beanName, owner, ctor, args2);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor ctor, Object[] args2) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    @Override
    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Object factoryBean, final Method factoryMethod, Object[] args2) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ReflectionUtils.makeAccessible(factoryMethod);
                    return null;
                }
            });
        } else {
            ReflectionUtils.makeAccessible(factoryMethod);
        }
        Method priorInvokedFactoryMethod = currentlyInvokedFactoryMethod.get();
        try {
            currentlyInvokedFactoryMethod.set(factoryMethod);
            Object object = factoryMethod.invoke(factoryBean, args2);
            if (priorInvokedFactoryMethod != null) {
                currentlyInvokedFactoryMethod.set(priorInvokedFactoryMethod);
            } else {
                currentlyInvokedFactoryMethod.remove();
            }
            return object;
        }
        catch (Throwable throwable2) {
            try {
                if (priorInvokedFactoryMethod != null) {
                    currentlyInvokedFactoryMethod.set(priorInvokedFactoryMethod);
                } else {
                    currentlyInvokedFactoryMethod.remove();
                }
                throw throwable2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BeanDefinitionStoreException("Illegal arguments to factory method [" + factoryMethod + "]; " + "args: " + StringUtils.arrayToCommaDelimitedString(args2));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BeanDefinitionStoreException("Cannot access factory method [" + factoryMethod + "]; is it public?");
            }
            catch (InvocationTargetException ex2) {
                throw new BeanDefinitionStoreException("Factory method [" + factoryMethod + "] threw exception", ex2.getTargetException());
            }
        }
    }

    public static Method getCurrentlyInvokedFactoryMethod() {
        return currentlyInvokedFactoryMethod.get();
    }
}

