/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractSimpleBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes2 = element2.getAttributes();
        int x = 0;
        while (x < attributes2.getLength()) {
            Attr attribute2 = (Attr)attributes2.item(x);
            if (this.isEligibleAttribute(attribute2, parserContext)) {
                String propertyName = this.extractPropertyName(attribute2.getLocalName());
                Assert.state(StringUtils.hasText(propertyName), "Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
                builder.addPropertyValue(propertyName, attribute2.getValue());
            }
            ++x;
        }
        this.postProcess(builder, element2);
    }

    protected boolean isEligibleAttribute(Attr attribute2, ParserContext parserContext) {
        boolean eligible = this.isEligibleAttribute(attribute2);
        if (!eligible) {
            String fullName = attribute2.getName();
            eligible = !fullName.equals("xmlns") && !fullName.startsWith("xmlns:") && this.isEligibleAttribute(parserContext.getDelegate().getLocalName(attribute2));
        }
        return eligible;
    }

    @Deprecated
    protected boolean isEligibleAttribute(Attr attribute2) {
        return false;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !"id".equals(attributeName);
    }

    protected String extractPropertyName(String attributeName) {
        return Conventions.attributeNameToPropertyName(attributeName);
    }

    protected void postProcess(BeanDefinitionBuilder beanDefinition, Element element2) {
    }
}

