/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.BeanMetadataAttributeAccessor;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanEntry;
import org.springframework.beans.factory.parsing.ConstructorArgumentEntry;
import org.springframework.beans.factory.parsing.ParseState;
import org.springframework.beans.factory.parsing.PropertyEntry;
import org.springframework.beans.factory.parsing.QualifierEntry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionDefaults;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.xml.DocumentDefaultsDefinition;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDefinitionParserDelegate {
    public static final String BEANS_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    public static final String MULTI_VALUE_ATTRIBUTE_DELIMITERS = ",; ";
    public static final String BEAN_NAME_DELIMITERS = ",; ";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    public static final String DEFAULT_VALUE = "default";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String AUTOWIRE_NO_VALUE = "no";
    public static final String AUTOWIRE_BY_NAME_VALUE = "byName";
    public static final String AUTOWIRE_BY_TYPE_VALUE = "byType";
    public static final String AUTOWIRE_CONSTRUCTOR_VALUE = "constructor";
    public static final String AUTOWIRE_AUTODETECT_VALUE = "autodetect";
    public static final String DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE = "all";
    public static final String DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE = "simple";
    public static final String DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE = "objects";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String BEAN_ELEMENT = "bean";
    public static final String META_ELEMENT = "meta";
    public static final String ID_ATTRIBUTE = "id";
    public static final String PARENT_ATTRIBUTE = "parent";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ABSTRACT_ATTRIBUTE = "abstract";
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static final String SINGLETON_ATTRIBUTE = "singleton";
    public static final String LAZY_INIT_ATTRIBUTE = "lazy-init";
    public static final String AUTOWIRE_ATTRIBUTE = "autowire";
    public static final String AUTOWIRE_CANDIDATE_ATTRIBUTE = "autowire-candidate";
    public static final String PRIMARY_ATTRIBUTE = "primary";
    public static final String DEPENDENCY_CHECK_ATTRIBUTE = "dependency-check";
    public static final String DEPENDS_ON_ATTRIBUTE = "depends-on";
    public static final String INIT_METHOD_ATTRIBUTE = "init-method";
    public static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";
    public static final String FACTORY_METHOD_ATTRIBUTE = "factory-method";
    public static final String FACTORY_BEAN_ATTRIBUTE = "factory-bean";
    public static final String CONSTRUCTOR_ARG_ELEMENT = "constructor-arg";
    public static final String INDEX_ATTRIBUTE = "index";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String VALUE_TYPE_ATTRIBUTE = "value-type";
    public static final String KEY_TYPE_ATTRIBUTE = "key-type";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String LOOKUP_METHOD_ELEMENT = "lookup-method";
    public static final String REPLACED_METHOD_ELEMENT = "replaced-method";
    public static final String REPLACER_ATTRIBUTE = "replacer";
    public static final String ARG_TYPE_ELEMENT = "arg-type";
    public static final String ARG_TYPE_MATCH_ATTRIBUTE = "match";
    public static final String REF_ELEMENT = "ref";
    public static final String IDREF_ELEMENT = "idref";
    public static final String BEAN_REF_ATTRIBUTE = "bean";
    public static final String LOCAL_REF_ATTRIBUTE = "local";
    public static final String PARENT_REF_ATTRIBUTE = "parent";
    public static final String VALUE_ELEMENT = "value";
    public static final String NULL_ELEMENT = "null";
    public static final String ARRAY_ELEMENT = "array";
    public static final String LIST_ELEMENT = "list";
    public static final String SET_ELEMENT = "set";
    public static final String MAP_ELEMENT = "map";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ELEMENT = "key";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String KEY_REF_ATTRIBUTE = "key-ref";
    public static final String VALUE_REF_ATTRIBUTE = "value-ref";
    public static final String PROPS_ELEMENT = "props";
    public static final String PROP_ELEMENT = "prop";
    public static final String MERGE_ATTRIBUTE = "merge";
    public static final String QUALIFIER_ELEMENT = "qualifier";
    public static final String QUALIFIER_ATTRIBUTE_ELEMENT = "attribute";
    public static final String DEFAULT_LAZY_INIT_ATTRIBUTE = "default-lazy-init";
    public static final String DEFAULT_MERGE_ATTRIBUTE = "default-merge";
    public static final String DEFAULT_AUTOWIRE_ATTRIBUTE = "default-autowire";
    public static final String DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE = "default-dependency-check";
    public static final String DEFAULT_AUTOWIRE_CANDIDATES_ATTRIBUTE = "default-autowire-candidates";
    public static final String DEFAULT_INIT_METHOD_ATTRIBUTE = "default-init-method";
    public static final String DEFAULT_DESTROY_METHOD_ATTRIBUTE = "default-destroy-method";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final XmlReaderContext readerContext;
    private final DocumentDefaultsDefinition defaults = new DocumentDefaultsDefinition();
    private final ParseState parseState = new ParseState();
    private Environment environment;
    private final Set<String> usedNames = new HashSet<String>();

    public BeanDefinitionParserDelegate(XmlReaderContext readerContext, Environment environment) {
        Assert.notNull(readerContext, "XmlReaderContext must not be null");
        Assert.notNull(readerContext, "Environment must not be null");
        this.readerContext = readerContext;
        this.environment = environment;
    }

    @Deprecated
    public BeanDefinitionParserDelegate(XmlReaderContext readerContext) {
        this(readerContext, new StandardEnvironment());
    }

    public final XmlReaderContext getReaderContext() {
        return this.readerContext;
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    protected Object extractSource(Element ele) {
        return this.readerContext.extractSource(ele);
    }

    protected void error(String message, Node source) {
        this.readerContext.error(message, (Object)source, this.parseState.snapshot());
    }

    protected void error(String message, Element source) {
        this.readerContext.error(message, (Object)source, this.parseState.snapshot());
    }

    protected void error(String message, Element source, Throwable cause) {
        this.readerContext.error(message, source, this.parseState.snapshot(), cause);
    }

    public void initDefaults(Element root2, BeanDefinitionParserDelegate parent2) {
        this.populateDefaults(this.defaults, parent2 != null ? parent2.defaults : null, root2);
        this.readerContext.fireDefaultsRegistered(this.defaults);
    }

    public void initDefaults(Element root2) {
        this.initDefaults(root2, null);
    }

    protected void populateDefaults(DocumentDefaultsDefinition defaults, DocumentDefaultsDefinition parentDefaults, Element root2) {
        String lazyInit = root2.getAttribute(DEFAULT_LAZY_INIT_ATTRIBUTE);
        if (DEFAULT_VALUE.equals(lazyInit)) {
            lazyInit = parentDefaults != null ? parentDefaults.getLazyInit() : FALSE_VALUE;
        }
        defaults.setLazyInit(lazyInit);
        String merge2 = root2.getAttribute(DEFAULT_MERGE_ATTRIBUTE);
        if (DEFAULT_VALUE.equals(merge2)) {
            merge2 = parentDefaults != null ? parentDefaults.getMerge() : FALSE_VALUE;
        }
        defaults.setMerge(merge2);
        String autowire = root2.getAttribute(DEFAULT_AUTOWIRE_ATTRIBUTE);
        if (DEFAULT_VALUE.equals(autowire)) {
            autowire = parentDefaults != null ? parentDefaults.getAutowire() : AUTOWIRE_NO_VALUE;
        }
        defaults.setAutowire(autowire);
        defaults.setDependencyCheck(root2.getAttribute(DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE));
        if (root2.hasAttribute(DEFAULT_AUTOWIRE_CANDIDATES_ATTRIBUTE)) {
            defaults.setAutowireCandidates(root2.getAttribute(DEFAULT_AUTOWIRE_CANDIDATES_ATTRIBUTE));
        } else if (parentDefaults != null) {
            defaults.setAutowireCandidates(parentDefaults.getAutowireCandidates());
        }
        if (root2.hasAttribute(DEFAULT_INIT_METHOD_ATTRIBUTE)) {
            defaults.setInitMethod(root2.getAttribute(DEFAULT_INIT_METHOD_ATTRIBUTE));
        } else if (parentDefaults != null) {
            defaults.setInitMethod(parentDefaults.getInitMethod());
        }
        if (root2.hasAttribute(DEFAULT_DESTROY_METHOD_ATTRIBUTE)) {
            defaults.setDestroyMethod(root2.getAttribute(DEFAULT_DESTROY_METHOD_ATTRIBUTE));
        } else if (parentDefaults != null) {
            defaults.setDestroyMethod(parentDefaults.getDestroyMethod());
        }
        defaults.setSource(this.readerContext.extractSource(root2));
    }

    public DocumentDefaultsDefinition getDefaults() {
        return this.defaults;
    }

    public BeanDefinitionDefaults getBeanDefinitionDefaults() {
        BeanDefinitionDefaults bdd = new BeanDefinitionDefaults();
        bdd.setLazyInit("TRUE".equalsIgnoreCase(this.defaults.getLazyInit()));
        bdd.setDependencyCheck(this.getDependencyCheck(DEFAULT_VALUE));
        bdd.setAutowireMode(this.getAutowireMode(DEFAULT_VALUE));
        bdd.setInitMethodName(this.defaults.getInitMethod());
        bdd.setDestroyMethodName(this.defaults.getDestroyMethod());
        return bdd;
    }

    public String[] getAutowireCandidatePatterns() {
        String candidatePattern = this.defaults.getAutowireCandidates();
        return candidatePattern != null ? StringUtils.commaDelimitedListToStringArray(candidatePattern) : null;
    }

    public BeanDefinitionHolder parseBeanDefinitionElement(Element ele) {
        return this.parseBeanDefinitionElement(ele, null);
    }

    public BeanDefinitionHolder parseBeanDefinitionElement(Element ele, BeanDefinition containingBean) {
        AbstractBeanDefinition beanDefinition;
        String beanName;
        String id2 = ele.getAttribute(ID_ATTRIBUTE);
        String nameAttr = ele.getAttribute(NAME_ATTRIBUTE);
        ArrayList<String> aliases2 = new ArrayList<String>();
        if (StringUtils.hasLength(nameAttr)) {
            String[] nameArr = StringUtils.tokenizeToStringArray(nameAttr, ",; ");
            aliases2.addAll((Collection)Arrays.asList(nameArr));
        }
        if (!StringUtils.hasText(beanName = id2) && !aliases2.isEmpty()) {
            beanName = (String)aliases2.remove(0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No XML 'id' specified - using '" + beanName + "' as bean name and " + aliases2 + " as aliases");
            }
        }
        if (containingBean == null) {
            this.checkNameUniqueness(beanName, aliases2, ele);
        }
        if ((beanDefinition = this.parseBeanDefinitionElement(ele, beanName, containingBean)) != null) {
            if (!StringUtils.hasText(beanName)) {
                try {
                    if (containingBean != null) {
                        beanName = BeanDefinitionReaderUtils.generateBeanName(beanDefinition, this.readerContext.getRegistry(), true);
                    } else {
                        beanName = this.readerContext.generateBeanName(beanDefinition);
                        String beanClassName = beanDefinition.getBeanClassName();
                        if (beanClassName != null && beanName.startsWith(beanClassName) && beanName.length() > beanClassName.length() && !this.readerContext.getRegistry().isBeanNameInUse(beanClassName)) {
                            aliases2.add(beanClassName);
                        }
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Neither XML 'id' nor 'name' specified - using generated bean name [" + beanName + "]");
                    }
                }
                catch (Exception ex2) {
                    this.error(ex2.getMessage(), ele);
                    return null;
                }
            }
            String[] aliasesArray = StringUtils.toStringArray(aliases2);
            return new BeanDefinitionHolder(beanDefinition, beanName, aliasesArray);
        }
        return null;
    }

    protected void checkNameUniqueness(String beanName, List<String> aliases2, Element beanElement) {
        String foundName = null;
        if (StringUtils.hasText(beanName) && this.usedNames.contains(beanName)) {
            foundName = beanName;
        }
        if (foundName == null) {
            foundName = (String)CollectionUtils.findFirstMatch(this.usedNames, aliases2);
        }
        if (foundName != null) {
            this.error("Bean name '" + foundName + "' is already used in this <beans> element", beanElement);
        }
        this.usedNames.add(beanName);
        this.usedNames.addAll(aliases2);
    }

    public AbstractBeanDefinition parseBeanDefinitionElement(Element ele, String beanName, BeanDefinition containingBean) {
        this.parseState.push(new BeanEntry(beanName));
        String className = null;
        if (ele.hasAttribute(CLASS_ATTRIBUTE)) {
            className = ele.getAttribute(CLASS_ATTRIBUTE).trim();
        }
        try {
            String parent2 = null;
            if (ele.hasAttribute("parent")) {
                parent2 = ele.getAttribute("parent");
            }
            AbstractBeanDefinition bd = this.createBeanDefinition(className, parent2);
            this.parseBeanDefinitionAttributes(ele, beanName, containingBean, bd);
            bd.setDescription(DomUtils.getChildElementValueByTagName(ele, DESCRIPTION_ELEMENT));
            this.parseMetaElements(ele, bd);
            this.parseLookupOverrideSubElements(ele, bd.getMethodOverrides());
            this.parseReplacedMethodSubElements(ele, bd.getMethodOverrides());
            this.parseConstructorArgElements(ele, bd);
            this.parsePropertyElements(ele, bd);
            this.parseQualifierElements(ele, bd);
            bd.setResource(this.readerContext.getResource());
            bd.setSource(this.extractSource(ele));
            AbstractBeanDefinition abstractBeanDefinition = bd;
            return abstractBeanDefinition;
        }
        catch (ClassNotFoundException ex2) {
            this.error("Bean class [" + className + "] not found", ele, ex2);
        }
        catch (NoClassDefFoundError err2) {
            this.error("Class that bean class [" + className + "] depends on not found", ele, err2);
        }
        catch (Throwable ex3) {
            this.error("Unexpected failure during bean definition parsing", ele, ex3);
        }
        finally {
            this.parseState.pop();
        }
        return null;
    }

    public AbstractBeanDefinition parseBeanDefinitionAttributes(Element ele, String beanName, BeanDefinition containingBean, AbstractBeanDefinition bd) {
        String autowireCandidate;
        String lazyInit;
        if (ele.hasAttribute(SCOPE_ATTRIBUTE)) {
            bd.setScope(ele.getAttribute(SCOPE_ATTRIBUTE));
            if (ele.hasAttribute(SINGLETON_ATTRIBUTE)) {
                this.error("Specify either 'scope' or 'singleton', not both", ele);
            }
        } else if (ele.hasAttribute(SINGLETON_ATTRIBUTE)) {
            bd.setScope(TRUE_VALUE.equals(ele.getAttribute(SINGLETON_ATTRIBUTE)) ? SINGLETON_ATTRIBUTE : "prototype");
        } else if (containingBean != null) {
            bd.setScope(containingBean.getScope());
        }
        if (ele.hasAttribute(ABSTRACT_ATTRIBUTE)) {
            bd.setAbstract(TRUE_VALUE.equals(ele.getAttribute(ABSTRACT_ATTRIBUTE)));
        }
        if (DEFAULT_VALUE.equals(lazyInit = ele.getAttribute(LAZY_INIT_ATTRIBUTE))) {
            lazyInit = this.defaults.getLazyInit();
        }
        bd.setLazyInit(TRUE_VALUE.equals(lazyInit));
        String autowire = ele.getAttribute(AUTOWIRE_ATTRIBUTE);
        bd.setAutowireMode(this.getAutowireMode(autowire));
        String dependencyCheck = ele.getAttribute(DEPENDENCY_CHECK_ATTRIBUTE);
        bd.setDependencyCheck(this.getDependencyCheck(dependencyCheck));
        if (ele.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
            String dependsOn2 = ele.getAttribute(DEPENDS_ON_ATTRIBUTE);
            bd.setDependsOn(StringUtils.tokenizeToStringArray(dependsOn2, ",; "));
        }
        if ("".equals(autowireCandidate = ele.getAttribute(AUTOWIRE_CANDIDATE_ATTRIBUTE)) || DEFAULT_VALUE.equals(autowireCandidate)) {
            String candidatePattern = this.defaults.getAutowireCandidates();
            if (candidatePattern != null) {
                String[] patterns2 = StringUtils.commaDelimitedListToStringArray(candidatePattern);
                bd.setAutowireCandidate(PatternMatchUtils.simpleMatch(patterns2, beanName));
            }
        } else {
            bd.setAutowireCandidate(TRUE_VALUE.equals(autowireCandidate));
        }
        if (ele.hasAttribute(PRIMARY_ATTRIBUTE)) {
            bd.setPrimary(TRUE_VALUE.equals(ele.getAttribute(PRIMARY_ATTRIBUTE)));
        }
        if (ele.hasAttribute(INIT_METHOD_ATTRIBUTE)) {
            String initMethodName = ele.getAttribute(INIT_METHOD_ATTRIBUTE);
            if (!"".equals(initMethodName)) {
                bd.setInitMethodName(initMethodName);
            }
        } else if (this.defaults.getInitMethod() != null) {
            bd.setInitMethodName(this.defaults.getInitMethod());
            bd.setEnforceInitMethod(false);
        }
        if (ele.hasAttribute(DESTROY_METHOD_ATTRIBUTE)) {
            String destroyMethodName = ele.getAttribute(DESTROY_METHOD_ATTRIBUTE);
            if (!"".equals(destroyMethodName)) {
                bd.setDestroyMethodName(destroyMethodName);
            }
        } else if (this.defaults.getDestroyMethod() != null) {
            bd.setDestroyMethodName(this.defaults.getDestroyMethod());
            bd.setEnforceDestroyMethod(false);
        }
        if (ele.hasAttribute(FACTORY_METHOD_ATTRIBUTE)) {
            bd.setFactoryMethodName(ele.getAttribute(FACTORY_METHOD_ATTRIBUTE));
        }
        if (ele.hasAttribute(FACTORY_BEAN_ATTRIBUTE)) {
            bd.setFactoryBeanName(ele.getAttribute(FACTORY_BEAN_ATTRIBUTE));
        }
        return bd;
    }

    protected AbstractBeanDefinition createBeanDefinition(String className, String parentName) throws ClassNotFoundException {
        return BeanDefinitionReaderUtils.createBeanDefinition(parentName, className, this.readerContext.getBeanClassLoader());
    }

    public void parseMetaElements(Element ele, BeanMetadataAttributeAccessor attributeAccessor) {
        NodeList nl = ele.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node4 = nl.item(i);
            if (this.isCandidateElement(node4) && this.nodeNameEquals(node4, META_ELEMENT)) {
                Element metaElement = (Element)node4;
                String key = metaElement.getAttribute("key");
                String value2 = metaElement.getAttribute("value");
                BeanMetadataAttribute attribute2 = new BeanMetadataAttribute(key, value2);
                attribute2.setSource(this.extractSource(metaElement));
                attributeAccessor.addMetadataAttribute(attribute2);
            }
            ++i;
        }
    }

    public int getAutowireMode(String attValue) {
        String att = attValue;
        if (DEFAULT_VALUE.equals(att)) {
            att = this.defaults.getAutowire();
        }
        int autowire = 0;
        if (AUTOWIRE_BY_NAME_VALUE.equals(att)) {
            autowire = 1;
        } else if (AUTOWIRE_BY_TYPE_VALUE.equals(att)) {
            autowire = 2;
        } else if (AUTOWIRE_CONSTRUCTOR_VALUE.equals(att)) {
            autowire = 3;
        } else if (AUTOWIRE_AUTODETECT_VALUE.equals(att)) {
            autowire = 4;
        }
        return autowire;
    }

    public int getDependencyCheck(String attValue) {
        String att = attValue;
        if (DEFAULT_VALUE.equals(att)) {
            att = this.defaults.getDependencyCheck();
        }
        if (DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE.equals(att)) {
            return 3;
        }
        if (DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE.equals(att)) {
            return 1;
        }
        if (DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE.equals(att)) {
            return 2;
        }
        return 0;
    }

    public void parseConstructorArgElements(Element beanEle, BeanDefinition bd) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node4 = nl.item(i);
            if (this.isCandidateElement(node4) && this.nodeNameEquals(node4, CONSTRUCTOR_ARG_ELEMENT)) {
                this.parseConstructorArgElement((Element)node4, bd);
            }
            ++i;
        }
    }

    public void parsePropertyElements(Element beanEle, BeanDefinition bd) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node4 = nl.item(i);
            if (this.isCandidateElement(node4) && this.nodeNameEquals(node4, PROPERTY_ELEMENT)) {
                this.parsePropertyElement((Element)node4, bd);
            }
            ++i;
        }
    }

    public void parseQualifierElements(Element beanEle, AbstractBeanDefinition bd) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node4 = nl.item(i);
            if (this.isCandidateElement(node4) && this.nodeNameEquals(node4, QUALIFIER_ELEMENT)) {
                this.parseQualifierElement((Element)node4, bd);
            }
            ++i;
        }
    }

    public void parseLookupOverrideSubElements(Element beanEle, MethodOverrides overrides) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node4 = nl.item(i);
            if (this.isCandidateElement(node4) && this.nodeNameEquals(node4, LOOKUP_METHOD_ELEMENT)) {
                Element ele = (Element)node4;
                String methodName = ele.getAttribute(NAME_ATTRIBUTE);
                String beanRef = ele.getAttribute("bean");
                LookupOverride override = new LookupOverride(methodName, beanRef);
                override.setSource(this.extractSource(ele));
                overrides.addOverride(override);
            }
            ++i;
        }
    }

    public void parseReplacedMethodSubElements(Element beanEle, MethodOverrides overrides) {
        NodeList nl = beanEle.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node4 = nl.item(i);
            if (this.isCandidateElement(node4) && this.nodeNameEquals(node4, REPLACED_METHOD_ELEMENT)) {
                Element replacedMethodEle = (Element)node4;
                String name = replacedMethodEle.getAttribute(NAME_ATTRIBUTE);
                String callback = replacedMethodEle.getAttribute(REPLACER_ATTRIBUTE);
                ReplaceOverride replaceOverride = new ReplaceOverride(name, callback);
                List<Element> argTypeEles = DomUtils.getChildElementsByTagName(replacedMethodEle, ARG_TYPE_ELEMENT);
                for (Element argTypeEle : argTypeEles) {
                    replaceOverride.addTypeIdentifier(argTypeEle.getAttribute(ARG_TYPE_MATCH_ATTRIBUTE));
                }
                replaceOverride.setSource(this.extractSource(replacedMethodEle));
                overrides.addOverride(replaceOverride);
            }
            ++i;
        }
    }

    public void parseConstructorArgElement(Element ele, BeanDefinition bd) {
        block17: {
            String indexAttr = ele.getAttribute(INDEX_ATTRIBUTE);
            String typeAttr = ele.getAttribute(TYPE_ATTRIBUTE);
            String nameAttr = ele.getAttribute(NAME_ATTRIBUTE);
            if (StringUtils.hasLength(indexAttr)) {
                try {
                    int index2 = Integer.parseInt(indexAttr);
                    if (index2 < 0) {
                        this.error("'index' cannot be lower than 0", ele);
                        break block17;
                    }
                    try {
                        this.parseState.push(new ConstructorArgumentEntry(index2));
                        Object value2 = this.parsePropertyValue(ele, bd, null);
                        ConstructorArgumentValues.ValueHolder valueHolder = new ConstructorArgumentValues.ValueHolder(value2);
                        if (StringUtils.hasLength(typeAttr)) {
                            valueHolder.setType(typeAttr);
                        }
                        if (StringUtils.hasLength(nameAttr)) {
                            valueHolder.setName(nameAttr);
                        }
                        valueHolder.setSource(this.extractSource(ele));
                        if (bd.getConstructorArgumentValues().hasIndexedArgumentValue(index2)) {
                            this.error("Ambiguous constructor-arg entries for index " + index2, ele);
                        } else {
                            bd.getConstructorArgumentValues().addIndexedArgumentValue(index2, valueHolder);
                        }
                    }
                    finally {
                        this.parseState.pop();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Attribute 'index' of tag 'constructor-arg' must be an integer", ele);
                }
            } else {
                try {
                    this.parseState.push(new ConstructorArgumentEntry());
                    Object value3 = this.parsePropertyValue(ele, bd, null);
                    ConstructorArgumentValues.ValueHolder valueHolder = new ConstructorArgumentValues.ValueHolder(value3);
                    if (StringUtils.hasLength(typeAttr)) {
                        valueHolder.setType(typeAttr);
                    }
                    if (StringUtils.hasLength(nameAttr)) {
                        valueHolder.setName(nameAttr);
                    }
                    valueHolder.setSource(this.extractSource(ele));
                    bd.getConstructorArgumentValues().addGenericArgumentValue(valueHolder);
                }
                finally {
                    this.parseState.pop();
                }
            }
        }
    }

    public void parsePropertyElement(Element ele, BeanDefinition bd) {
        String propertyName = ele.getAttribute(NAME_ATTRIBUTE);
        if (!StringUtils.hasLength(propertyName)) {
            this.error("Tag 'property' must have a 'name' attribute", ele);
            return;
        }
        this.parseState.push(new PropertyEntry(propertyName));
        try {
            if (bd.getPropertyValues().contains(propertyName)) {
                this.error("Multiple 'property' definitions for property '" + propertyName + "'", ele);
                return;
            }
            Object val = this.parsePropertyValue(ele, bd, propertyName);
            PropertyValue pv2 = new PropertyValue(propertyName, val);
            this.parseMetaElements(ele, pv2);
            pv2.setSource(this.extractSource(ele));
            bd.getPropertyValues().addPropertyValue(pv2);
        }
        finally {
            this.parseState.pop();
        }
    }

    public void parseQualifierElement(Element ele, AbstractBeanDefinition bd) {
        String typeName = ele.getAttribute(TYPE_ATTRIBUTE);
        if (!StringUtils.hasLength(typeName)) {
            this.error("Tag 'qualifier' must have a 'type' attribute", ele);
            return;
        }
        this.parseState.push(new QualifierEntry(typeName));
        try {
            AutowireCandidateQualifier qualifier = new AutowireCandidateQualifier(typeName);
            qualifier.setSource(this.extractSource(ele));
            String value2 = ele.getAttribute("value");
            if (StringUtils.hasLength(value2)) {
                qualifier.setAttribute(AutowireCandidateQualifier.VALUE_KEY, value2);
            }
            NodeList nl = ele.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node4 = nl.item(i);
                if (this.isCandidateElement(node4) && this.nodeNameEquals(node4, QUALIFIER_ATTRIBUTE_ELEMENT)) {
                    Element attributeEle = (Element)node4;
                    String attributeName = attributeEle.getAttribute("key");
                    String attributeValue = attributeEle.getAttribute("value");
                    if (StringUtils.hasLength(attributeName) && StringUtils.hasLength(attributeValue)) {
                        BeanMetadataAttribute attribute2 = new BeanMetadataAttribute(attributeName, attributeValue);
                        attribute2.setSource(this.extractSource(attributeEle));
                        qualifier.addMetadataAttribute(attribute2);
                    } else {
                        this.error("Qualifier 'attribute' tag must have a 'name' and 'value'", attributeEle);
                        return;
                    }
                }
                ++i;
            }
            bd.addQualifier(qualifier);
        }
        finally {
            this.parseState.pop();
        }
    }

    public Object parsePropertyValue(Element ele, BeanDefinition bd, String propertyName) {
        String elementName = propertyName != null ? "<property> element for property '" + propertyName + "'" : "<constructor-arg> element";
        NodeList nl = ele.getChildNodes();
        Element subElement = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node node4 = nl.item(i);
            if (node4 instanceof Element && !this.nodeNameEquals(node4, DESCRIPTION_ELEMENT) && !this.nodeNameEquals(node4, META_ELEMENT)) {
                if (subElement != null) {
                    this.error(String.valueOf(elementName) + " must not contain more than one sub-element", ele);
                } else {
                    subElement = (Element)node4;
                }
            }
            ++i;
        }
        boolean hasRefAttribute = ele.hasAttribute("ref");
        boolean hasValueAttribute = ele.hasAttribute("value");
        if (hasRefAttribute && hasValueAttribute || (hasRefAttribute || hasValueAttribute) && subElement != null) {
            this.error(String.valueOf(elementName) + " is only allowed to contain either 'ref' attribute OR 'value' attribute OR sub-element", ele);
        }
        if (hasRefAttribute) {
            String refName = ele.getAttribute("ref");
            if (!StringUtils.hasText(refName)) {
                this.error(String.valueOf(elementName) + " contains empty 'ref' attribute", ele);
            }
            RuntimeBeanReference ref = new RuntimeBeanReference(refName);
            ref.setSource(this.extractSource(ele));
            return ref;
        }
        if (hasValueAttribute) {
            TypedStringValue valueHolder = new TypedStringValue(ele.getAttribute("value"));
            valueHolder.setSource(this.extractSource(ele));
            return valueHolder;
        }
        if (subElement != null) {
            return this.parsePropertySubElement(subElement, bd);
        }
        this.error(String.valueOf(elementName) + " must specify a ref or value", ele);
        return null;
    }

    public Object parsePropertySubElement(Element ele, BeanDefinition bd) {
        return this.parsePropertySubElement(ele, bd, null);
    }

    public Object parsePropertySubElement(Element ele, BeanDefinition bd, String defaultValueType) {
        if (!this.isDefaultNamespace(ele)) {
            return this.parseNestedCustomElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, "bean")) {
            BeanDefinitionHolder nestedBd = this.parseBeanDefinitionElement(ele, bd);
            if (nestedBd != null) {
                nestedBd = this.decorateBeanDefinitionIfRequired(ele, nestedBd, bd);
            }
            return nestedBd;
        }
        if (this.nodeNameEquals(ele, "ref")) {
            String refName = ele.getAttribute("bean");
            boolean toParent = false;
            if (!StringUtils.hasLength(refName) && !StringUtils.hasLength(refName = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                refName = ele.getAttribute("parent");
                toParent = true;
                if (!StringUtils.hasLength(refName)) {
                    this.error("'bean', 'local' or 'parent' is required for <ref> element", ele);
                    return null;
                }
            }
            if (!StringUtils.hasText(refName)) {
                this.error("<ref> element contains empty target attribute", ele);
                return null;
            }
            RuntimeBeanReference ref = new RuntimeBeanReference(refName, toParent);
            ref.setSource(this.extractSource(ele));
            return ref;
        }
        if (this.nodeNameEquals(ele, IDREF_ELEMENT)) {
            return this.parseIdRefElement(ele);
        }
        if (this.nodeNameEquals(ele, "value")) {
            return this.parseValueElement(ele, defaultValueType);
        }
        if (this.nodeNameEquals(ele, NULL_ELEMENT)) {
            TypedStringValue nullHolder = new TypedStringValue(null);
            nullHolder.setSource(this.extractSource(ele));
            return nullHolder;
        }
        if (this.nodeNameEquals(ele, ARRAY_ELEMENT)) {
            return this.parseArrayElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, LIST_ELEMENT)) {
            return this.parseListElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, SET_ELEMENT)) {
            return this.parseSetElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, MAP_ELEMENT)) {
            return this.parseMapElement(ele, bd);
        }
        if (this.nodeNameEquals(ele, PROPS_ELEMENT)) {
            return this.parsePropsElement(ele);
        }
        this.error("Unknown property sub-element: [" + ele.getNodeName() + "]", ele);
        return null;
    }

    public Object parseIdRefElement(Element ele) {
        String refName = ele.getAttribute("bean");
        if (!StringUtils.hasLength(refName) && !StringUtils.hasLength(refName = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
            this.error("Either 'bean' or 'local' is required for <idref> element", ele);
            return null;
        }
        if (!StringUtils.hasText(refName)) {
            this.error("<idref> element contains empty target attribute", ele);
            return null;
        }
        RuntimeBeanNameReference ref = new RuntimeBeanNameReference(refName);
        ref.setSource(this.extractSource(ele));
        return ref;
    }

    public Object parseValueElement(Element ele, String defaultTypeName) {
        String value2 = DomUtils.getTextValue(ele);
        String specifiedTypeName = ele.getAttribute(TYPE_ATTRIBUTE);
        String typeName = specifiedTypeName;
        if (!StringUtils.hasText(typeName)) {
            typeName = defaultTypeName;
        }
        try {
            TypedStringValue typedValue = this.buildTypedStringValue(value2, typeName);
            typedValue.setSource(this.extractSource(ele));
            typedValue.setSpecifiedTypeName(specifiedTypeName);
            return typedValue;
        }
        catch (ClassNotFoundException ex2) {
            this.error("Type class [" + typeName + "] not found for <value> element", ele, ex2);
            return value2;
        }
    }

    protected TypedStringValue buildTypedStringValue(String value2, String targetTypeName) throws ClassNotFoundException {
        TypedStringValue typedValue;
        ClassLoader classLoader = this.readerContext.getBeanClassLoader();
        if (!StringUtils.hasText(targetTypeName)) {
            typedValue = new TypedStringValue(value2);
        } else if (classLoader != null) {
            Class<?> targetType = ClassUtils.forName(targetTypeName, classLoader);
            typedValue = new TypedStringValue(value2, targetType);
        } else {
            typedValue = new TypedStringValue(value2, targetTypeName);
        }
        return typedValue;
    }

    public Object parseArrayElement(Element arrayEle, BeanDefinition bd) {
        String elementType2 = arrayEle.getAttribute(VALUE_TYPE_ATTRIBUTE);
        NodeList nl = arrayEle.getChildNodes();
        ManagedArray target2 = new ManagedArray(elementType2, nl.getLength());
        target2.setSource(this.extractSource(arrayEle));
        target2.setElementTypeName(elementType2);
        target2.setMergeEnabled(this.parseMergeAttribute(arrayEle));
        this.parseCollectionElements(nl, target2, bd, elementType2);
        return target2;
    }

    public List parseListElement(Element collectionEle, BeanDefinition bd) {
        String defaultElementType = collectionEle.getAttribute(VALUE_TYPE_ATTRIBUTE);
        NodeList nl = collectionEle.getChildNodes();
        ManagedList<Object> target2 = new ManagedList<Object>(nl.getLength());
        target2.setSource(this.extractSource(collectionEle));
        target2.setElementTypeName(defaultElementType);
        target2.setMergeEnabled(this.parseMergeAttribute(collectionEle));
        this.parseCollectionElements(nl, target2, bd, defaultElementType);
        return target2;
    }

    public Set parseSetElement(Element collectionEle, BeanDefinition bd) {
        String defaultElementType = collectionEle.getAttribute(VALUE_TYPE_ATTRIBUTE);
        NodeList nl = collectionEle.getChildNodes();
        ManagedSet<Object> target2 = new ManagedSet<Object>(nl.getLength());
        target2.setSource(this.extractSource(collectionEle));
        target2.setElementTypeName(defaultElementType);
        target2.setMergeEnabled(this.parseMergeAttribute(collectionEle));
        this.parseCollectionElements(nl, target2, bd, defaultElementType);
        return target2;
    }

    protected void parseCollectionElements(NodeList elementNodes, Collection<Object> target2, BeanDefinition bd, String defaultElementType) {
        int i = 0;
        while (i < elementNodes.getLength()) {
            Node node4 = elementNodes.item(i);
            if (node4 instanceof Element && !this.nodeNameEquals(node4, DESCRIPTION_ELEMENT)) {
                target2.add(this.parsePropertySubElement((Element)node4, bd, defaultElementType));
            }
            ++i;
        }
    }

    public Map parseMapElement(Element mapEle, BeanDefinition bd) {
        String defaultKeyType = mapEle.getAttribute(KEY_TYPE_ATTRIBUTE);
        String defaultValueType = mapEle.getAttribute(VALUE_TYPE_ATTRIBUTE);
        List<Element> entryEles = DomUtils.getChildElementsByTagName(mapEle, ENTRY_ELEMENT);
        ManagedMap<Object, Object> map3 = new ManagedMap<Object, Object>(entryEles.size());
        map3.setSource(this.extractSource(mapEle));
        map3.setKeyTypeName(defaultKeyType);
        map3.setValueTypeName(defaultValueType);
        map3.setMergeEnabled(this.parseMergeAttribute(mapEle));
        for (Element entryEle : entryEles) {
            NodeList entrySubNodes = entryEle.getChildNodes();
            Element keyEle = null;
            Element valueEle = null;
            int j = 0;
            while (j < entrySubNodes.getLength()) {
                Node node4 = entrySubNodes.item(j);
                if (node4 instanceof Element) {
                    Element candidateEle = (Element)node4;
                    if (this.nodeNameEquals(candidateEle, "key")) {
                        if (keyEle != null) {
                            this.error("<entry> element is only allowed to contain one <key> sub-element", entryEle);
                        } else {
                            keyEle = candidateEle;
                        }
                    } else if (!this.nodeNameEquals(candidateEle, DESCRIPTION_ELEMENT)) {
                        if (valueEle != null) {
                            this.error("<entry> element must not contain more than one value sub-element", entryEle);
                        } else {
                            valueEle = candidateEle;
                        }
                    }
                }
                ++j;
            }
            Object key = null;
            boolean hasKeyAttribute = entryEle.hasAttribute("key");
            boolean hasKeyRefAttribute = entryEle.hasAttribute(KEY_REF_ATTRIBUTE);
            if (hasKeyAttribute && hasKeyRefAttribute || (hasKeyAttribute || hasKeyRefAttribute) && keyEle != null) {
                this.error("<entry> element is only allowed to contain either a 'key' attribute OR a 'key-ref' attribute OR a <key> sub-element", entryEle);
            }
            if (hasKeyAttribute) {
                key = this.buildTypedStringValueForMap(entryEle.getAttribute("key"), defaultKeyType, entryEle);
            } else if (hasKeyRefAttribute) {
                String refName = entryEle.getAttribute(KEY_REF_ATTRIBUTE);
                if (!StringUtils.hasText(refName)) {
                    this.error("<entry> element contains empty 'key-ref' attribute", entryEle);
                }
                RuntimeBeanReference ref = new RuntimeBeanReference(refName);
                ref.setSource(this.extractSource(entryEle));
                key = ref;
            } else if (keyEle != null) {
                key = this.parseKeyElement(keyEle, bd, defaultKeyType);
            } else {
                this.error("<entry> element must specify a key", entryEle);
            }
            Object value2 = null;
            boolean hasValueAttribute = entryEle.hasAttribute("value");
            boolean hasValueRefAttribute = entryEle.hasAttribute(VALUE_REF_ATTRIBUTE);
            if (hasValueAttribute && hasValueRefAttribute || (hasValueAttribute || hasValueRefAttribute) && valueEle != null) {
                this.error("<entry> element is only allowed to contain either 'value' attribute OR 'value-ref' attribute OR <value> sub-element", entryEle);
            }
            if (hasValueAttribute) {
                value2 = this.buildTypedStringValueForMap(entryEle.getAttribute("value"), defaultValueType, entryEle);
            } else if (hasValueRefAttribute) {
                String refName = entryEle.getAttribute(VALUE_REF_ATTRIBUTE);
                if (!StringUtils.hasText(refName)) {
                    this.error("<entry> element contains empty 'value-ref' attribute", entryEle);
                }
                RuntimeBeanReference ref = new RuntimeBeanReference(refName);
                ref.setSource(this.extractSource(entryEle));
                value2 = ref;
            } else if (valueEle != null) {
                value2 = this.parsePropertySubElement(valueEle, bd, defaultValueType);
            } else {
                this.error("<entry> element must specify a value", entryEle);
            }
            map3.put(key, value2);
        }
        return map3;
    }

    protected final Object buildTypedStringValueForMap(String value2, String defaultTypeName, Element entryEle) {
        try {
            TypedStringValue typedValue = this.buildTypedStringValue(value2, defaultTypeName);
            typedValue.setSource(this.extractSource(entryEle));
            return typedValue;
        }
        catch (ClassNotFoundException ex2) {
            this.error("Type class [" + defaultTypeName + "] not found for Map key/value type", entryEle, ex2);
            return value2;
        }
    }

    protected Object parseKeyElement(Element keyEle, BeanDefinition bd, String defaultKeyTypeName) {
        NodeList nl = keyEle.getChildNodes();
        Element subElement = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node node4 = nl.item(i);
            if (node4 instanceof Element) {
                if (subElement != null) {
                    this.error("<key> element must not contain more than one value sub-element", keyEle);
                } else {
                    subElement = (Element)node4;
                }
            }
            ++i;
        }
        return this.parsePropertySubElement(subElement, bd, defaultKeyTypeName);
    }

    public Properties parsePropsElement(Element propsEle) {
        ManagedProperties props = new ManagedProperties();
        props.setSource(this.extractSource(propsEle));
        props.setMergeEnabled(this.parseMergeAttribute(propsEle));
        List<Element> propEles = DomUtils.getChildElementsByTagName(propsEle, PROP_ELEMENT);
        for (Element propEle : propEles) {
            String key = propEle.getAttribute("key");
            String value2 = DomUtils.getTextValue(propEle).trim();
            TypedStringValue keyHolder = new TypedStringValue(key);
            keyHolder.setSource(this.extractSource(propEle));
            TypedStringValue valueHolder = new TypedStringValue(value2);
            valueHolder.setSource(this.extractSource(propEle));
            props.put(keyHolder, valueHolder);
        }
        return props;
    }

    public boolean parseMergeAttribute(Element collectionElement) {
        String value2 = collectionElement.getAttribute(MERGE_ATTRIBUTE);
        if (DEFAULT_VALUE.equals(value2)) {
            value2 = this.defaults.getMerge();
        }
        return TRUE_VALUE.equals(value2);
    }

    public BeanDefinition parseCustomElement(Element ele) {
        return this.parseCustomElement(ele, null);
    }

    public BeanDefinition parseCustomElement(Element ele, BeanDefinition containingBd) {
        String namespaceUri = this.getNamespaceURI(ele);
        NamespaceHandler handler = this.readerContext.getNamespaceHandlerResolver().resolve(namespaceUri);
        if (handler == null) {
            this.error("Unable to locate Spring NamespaceHandler for XML schema namespace [" + namespaceUri + "]", ele);
            return null;
        }
        return handler.parse(ele, new ParserContext(this.readerContext, this, containingBd));
    }

    public BeanDefinitionHolder decorateBeanDefinitionIfRequired(Element ele, BeanDefinitionHolder definitionHolder) {
        return this.decorateBeanDefinitionIfRequired(ele, definitionHolder, null);
    }

    public BeanDefinitionHolder decorateBeanDefinitionIfRequired(Element ele, BeanDefinitionHolder definitionHolder, BeanDefinition containingBd) {
        BeanDefinitionHolder finalDefinition = definitionHolder;
        NamedNodeMap attributes2 = ele.getAttributes();
        int i = 0;
        while (i < attributes2.getLength()) {
            Node node4 = attributes2.item(i);
            finalDefinition = this.decorateIfRequired(node4, finalDefinition, containingBd);
            ++i;
        }
        NodeList children2 = ele.getChildNodes();
        int i2 = 0;
        while (i2 < children2.getLength()) {
            Node node5 = children2.item(i2);
            if (node5.getNodeType() == 1) {
                finalDefinition = this.decorateIfRequired(node5, finalDefinition, containingBd);
            }
            ++i2;
        }
        return finalDefinition;
    }

    private BeanDefinitionHolder decorateIfRequired(Node node4, BeanDefinitionHolder originalDef, BeanDefinition containingBd) {
        String namespaceUri = this.getNamespaceURI(node4);
        if (!this.isDefaultNamespace(namespaceUri)) {
            NamespaceHandler handler = this.readerContext.getNamespaceHandlerResolver().resolve(namespaceUri);
            if (handler != null) {
                return handler.decorate(node4, originalDef, new ParserContext(this.readerContext, this, containingBd));
            }
            if (namespaceUri != null && namespaceUri.startsWith("http://www.springframework.org/")) {
                this.error("Unable to locate Spring NamespaceHandler for XML schema namespace [" + namespaceUri + "]", node4);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("No Spring NamespaceHandler found for XML schema namespace [" + namespaceUri + "]");
            }
        }
        return originalDef;
    }

    private BeanDefinitionHolder parseNestedCustomElement(Element ele, BeanDefinition containingBd) {
        BeanDefinition innerDefinition = this.parseCustomElement(ele, containingBd);
        if (innerDefinition == null) {
            this.error("Incorrect usage of element '" + ele.getNodeName() + "' in a nested manner. " + "This tag cannot be used nested inside <property>.", ele);
            return null;
        }
        String id2 = String.valueOf(ele.getNodeName()) + "#" + ObjectUtils.getIdentityHexString(innerDefinition);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using generated bean name [" + id2 + "] for nested custom element '" + ele.getNodeName() + "'");
        }
        return new BeanDefinitionHolder(innerDefinition, id2);
    }

    public String getNamespaceURI(Node node4) {
        return node4.getNamespaceURI();
    }

    public String getLocalName(Node node4) {
        return node4.getLocalName();
    }

    public boolean nodeNameEquals(Node node4, String desiredName) {
        return desiredName.equals(node4.getNodeName()) || desiredName.equals(this.getLocalName(node4));
    }

    public boolean isDefaultNamespace(String namespaceUri) {
        return !StringUtils.hasLength(namespaceUri) || BEANS_NAMESPACE_URI.equals(namespaceUri);
    }

    public boolean isDefaultNamespace(Node node4) {
        return this.isDefaultNamespace(this.getNamespaceURI(node4));
    }

    private boolean isCandidateElement(Node node4) {
        return node4 instanceof Element && (this.isDefaultNamespace(node4) || !this.isDefaultNamespace(node4.getParentNode()));
    }
}

