/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.Collection;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConstructorNamespaceHandler
implements NamespaceHandler {
    private static final String REF_SUFFIX = "-ref";
    private static final String DELIMITER_PREFIX = "_";

    @Override
    public void init() {
    }

    @Override
    public BeanDefinition parse(Element element2, ParserContext parserContext) {
        parserContext.getReaderContext().error("Class [" + this.getClass().getName() + "] does not support custom elements.", element2);
        return null;
    }

    @Override
    public BeanDefinitionHolder decorate(Node node4, BeanDefinitionHolder definition, ParserContext parserContext) {
        if (node4 instanceof Attr) {
            Attr attr = (Attr)node4;
            String argName = StringUtils.trimWhitespace(parserContext.getDelegate().getLocalName(attr));
            String argValue = StringUtils.trimWhitespace(attr.getValue());
            ConstructorArgumentValues cvs = definition.getBeanDefinition().getConstructorArgumentValues();
            boolean ref = false;
            if (argName.endsWith(REF_SUFFIX)) {
                ref = true;
                argName = argName.substring(0, argName.length() - REF_SUFFIX.length());
            }
            ConstructorArgumentValues.ValueHolder valueHolder = new ConstructorArgumentValues.ValueHolder(ref ? new RuntimeBeanReference(argValue) : argValue);
            valueHolder.setSource(parserContext.getReaderContext().extractSource(attr));
            if (argName.startsWith(DELIMITER_PREFIX)) {
                String arg = argName.substring(1).trim();
                if (!StringUtils.hasText(arg)) {
                    cvs.addGenericArgumentValue(valueHolder);
                } else {
                    int index2 = -1;
                    try {
                        index2 = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException numberFormatException) {
                        parserContext.getReaderContext().error("Constructor argument '" + argName + "' specifies an invalid integer", attr);
                    }
                    if (index2 < 0) {
                        parserContext.getReaderContext().error("Constructor argument '" + argName + "' specifies a negative index", attr);
                    }
                    if (cvs.hasIndexedArgumentValue(index2)) {
                        parserContext.getReaderContext().error("Constructor argument '" + argName + "' with index " + index2 + " already defined using <constructor-arg>." + " Only one approach may be used per argument.", attr);
                    }
                    cvs.addIndexedArgumentValue(index2, valueHolder);
                }
            } else {
                String name = Conventions.attributeNameToPropertyName(argName);
                if (this.containsArgWithName(name, cvs)) {
                    parserContext.getReaderContext().error("Constructor argument '" + argName + "' already defined using <constructor-arg>." + " Only one approach may be used per argument.", attr);
                }
                valueHolder.setName(Conventions.attributeNameToPropertyName(argName));
                cvs.addGenericArgumentValue(valueHolder);
            }
        }
        return definition;
    }

    private boolean containsArgWithName(String name, ConstructorArgumentValues cvs) {
        if (!this.checkName(name, cvs.getGenericArgumentValues())) {
            return this.checkName(name, cvs.getIndexedArgumentValues().values());
        }
        return true;
    }

    private boolean checkName(String name, Collection<ConstructorArgumentValues.ValueHolder> values2) {
        for (ConstructorArgumentValues.ValueHolder holder : values2) {
            if (!name.equals(holder.getName())) continue;
            return true;
        }
        return false;
    }
}

