/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ClassArrayEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public ClassArrayEditor() {
        this(null);
    }

    public ClassArrayEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        if (StringUtils.hasText(text2)) {
            String[] classNames2 = StringUtils.commaDelimitedListToStringArray(text2);
            Class[] classes2 = new Class[classNames2.length];
            int i = 0;
            while (i < classNames2.length) {
                String className = classNames2[i].trim();
                classes2[i] = ClassUtils.resolveClassName(className, this.classLoader);
                ++i;
            }
            this.setValue(classes2);
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        Object[] classes2 = (Class[])this.getValue();
        if (ObjectUtils.isEmpty(classes2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < classes2.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(ClassUtils.getQualifiedName(classes2[i]));
            ++i;
        }
        return sb.toString();
    }
}

