/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class CustomCollectionEditor
extends PropertyEditorSupport {
    private final Class collectionType;
    private final boolean nullAsEmptyCollection;

    public CustomCollectionEditor(Class collectionType) {
        this(collectionType, false);
    }

    public CustomCollectionEditor(Class collectionType, boolean nullAsEmptyCollection) {
        if (collectionType == null) {
            throw new IllegalArgumentException("Collection type is required");
        }
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type [" + collectionType.getName() + "] does not implement [java.util.Collection]");
        }
        this.collectionType = collectionType;
        this.nullAsEmptyCollection = nullAsEmptyCollection;
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        this.setValue(text2);
    }

    public void setValue(Object value2) {
        if (value2 == null && this.nullAsEmptyCollection) {
            super.setValue(this.createCollection(this.collectionType, 0));
        } else if (value2 == null || this.collectionType.isInstance(value2) && !this.alwaysCreateNewCollection()) {
            super.setValue(value2);
        } else if (value2 instanceof Collection) {
            Collection source = (Collection)value2;
            Collection target2 = this.createCollection(this.collectionType, source.size());
            for (Object elem2 : source) {
                target2.add(this.convertElement(elem2));
            }
            super.setValue(target2);
        } else if (value2.getClass().isArray()) {
            int length2 = Array.getLength(value2);
            Collection target3 = this.createCollection(this.collectionType, length2);
            int i = 0;
            while (i < length2) {
                target3.add(this.convertElement(Array.get(value2, i)));
                ++i;
            }
            super.setValue(target3);
        } else {
            Collection target4 = this.createCollection(this.collectionType, 1);
            target4.add(this.convertElement(value2));
            super.setValue(target4);
        }
    }

    protected Collection createCollection(Class collectionType, int initialCapacity) {
        if (!collectionType.isInterface()) {
            try {
                return (Collection)collectionType.newInstance();
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException("Could not instantiate collection class [" + collectionType.getName() + "]: " + ex2.getMessage());
            }
        }
        if (List.class.equals((Object)collectionType)) {
            return new ArrayList(initialCapacity);
        }
        if (SortedSet.class.equals((Object)collectionType)) {
            return new TreeSet();
        }
        return new LinkedHashSet(initialCapacity);
    }

    protected boolean alwaysCreateNewCollection() {
        return false;
    }

    protected Object convertElement(Object element2) {
        return element2;
    }

    public String getAsText() {
        return null;
    }
}

