/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.springframework.util.StringUtils;

public class CustomDateEditor
extends PropertyEditorSupport {
    private final DateFormat dateFormat;
    private final boolean allowEmpty;
    private final int exactDateLength;

    public CustomDateEditor(DateFormat dateFormat, boolean allowEmpty) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
        this.exactDateLength = -1;
    }

    public CustomDateEditor(DateFormat dateFormat, boolean allowEmpty, int exactDateLength) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
        this.exactDateLength = exactDateLength;
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText(text2)) {
            this.setValue(null);
        } else {
            if (text2 != null && this.exactDateLength >= 0 && text2.length() != this.exactDateLength) {
                throw new IllegalArgumentException("Could not parse date: it is not exactly" + this.exactDateLength + "characters long");
            }
            try {
                this.setValue(this.dateFormat.parse(text2));
            }
            catch (ParseException ex2) {
                throw new IllegalArgumentException("Could not parse date: " + ex2.getMessage(), ex2);
            }
        }
    }

    public String getAsText() {
        Date value2 = (Date)this.getValue();
        return value2 != null ? this.dateFormat.format(value2) : "";
    }
}

