/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CustomMapEditor
extends PropertyEditorSupport {
    private final Class mapType;
    private final boolean nullAsEmptyMap;

    public CustomMapEditor(Class mapType2) {
        this(mapType2, false);
    }

    public CustomMapEditor(Class mapType2, boolean nullAsEmptyMap) {
        if (mapType2 == null) {
            throw new IllegalArgumentException("Map type is required");
        }
        if (!Map.class.isAssignableFrom(mapType2)) {
            throw new IllegalArgumentException("Map type [" + mapType2.getName() + "] does not implement [java.util.Map]");
        }
        this.mapType = mapType2;
        this.nullAsEmptyMap = nullAsEmptyMap;
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        this.setValue(text2);
    }

    public void setValue(Object value2) {
        if (value2 == null && this.nullAsEmptyMap) {
            super.setValue(this.createMap(this.mapType, 0));
        } else if (value2 == null || this.mapType.isInstance(value2) && !this.alwaysCreateNewMap()) {
            super.setValue(value2);
        } else if (value2 instanceof Map) {
            Map source = (Map)value2;
            Map target2 = this.createMap(this.mapType, source.size());
            for (Map.Entry entry2 : source.entrySet()) {
                target2.put(this.convertKey(entry2.getKey()), this.convertValue(entry2.getValue()));
            }
            super.setValue(target2);
        } else {
            throw new IllegalArgumentException("Value cannot be converted to Map: " + value2);
        }
    }

    protected Map createMap(Class mapType2, int initialCapacity) {
        if (!mapType2.isInterface()) {
            try {
                return (Map)mapType2.newInstance();
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException("Could not instantiate map class [" + mapType2.getName() + "]: " + ex2.getMessage());
            }
        }
        if (SortedMap.class.equals((Object)mapType2)) {
            return new TreeMap();
        }
        return new LinkedHashMap(initialCapacity);
    }

    protected boolean alwaysCreateNewMap() {
        return false;
    }

    protected Object convertKey(Object key) {
        return key;
    }

    protected Object convertValue(Object value2) {
        return value2;
    }

    public String getAsText() {
        return null;
    }
}

