/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.util.Assert;
import org.xml.sax.InputSource;

public class InputSourceEditor
extends PropertyEditorSupport {
    private final ResourceEditor resourceEditor;

    public InputSourceEditor() {
        this.resourceEditor = new ResourceEditor();
    }

    public InputSourceEditor(ResourceEditor resourceEditor) {
        Assert.notNull(resourceEditor, "ResourceEditor must not be null");
        this.resourceEditor = resourceEditor;
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        this.resourceEditor.setAsText(text2);
        Resource resource = (Resource)this.resourceEditor.getValue();
        try {
            this.setValue(resource != null ? new InputSource(resource.getURL().toString()) : null);
        }
        catch (IOException ex2) {
            throw new IllegalArgumentException("Could not retrieve URL for " + resource + ": " + ex2.getMessage());
        }
    }

    public String getAsText() {
        InputSource value2 = (InputSource)this.getValue();
        return value2 != null ? value2.getSystemId() : "";
    }
}

