/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class URIEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;
    private final boolean encode;

    public URIEditor() {
        this.classLoader = null;
        this.encode = true;
    }

    public URIEditor(boolean encode2) {
        this.classLoader = null;
        this.encode = encode2;
    }

    public URIEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        this.encode = true;
    }

    public URIEditor(ClassLoader classLoader, boolean encode2) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        this.encode = encode2;
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        if (StringUtils.hasText(text2)) {
            String uri = text2.trim();
            if (this.classLoader != null && uri.startsWith("classpath:")) {
                ClassPathResource resource = new ClassPathResource(uri.substring("classpath:".length()), this.classLoader);
                try {
                    String url = resource.getURL().toString();
                    this.setValue(this.createURI(url));
                }
                catch (IOException ex2) {
                    throw new IllegalArgumentException("Could not retrieve URI for " + resource + ": " + ex2.getMessage());
                }
                catch (URISyntaxException ex3) {
                    throw new IllegalArgumentException("Invalid URI syntax: " + ex3);
                }
            } else {
                try {
                    this.setValue(this.createURI(uri));
                }
                catch (URISyntaxException ex4) {
                    throw new IllegalArgumentException("Invalid URI syntax: " + ex4);
                }
            }
        } else {
            this.setValue(null);
        }
    }

    protected URI createURI(String value2) throws URISyntaxException {
        int colonIndex = value2.indexOf(58);
        if (this.encode && colonIndex != -1) {
            int fragmentIndex = value2.indexOf(35, colonIndex + 1);
            String scheme = value2.substring(0, colonIndex);
            String ssp = value2.substring(colonIndex + 1, fragmentIndex > 0 ? fragmentIndex : value2.length());
            String fragment = fragmentIndex > 0 ? value2.substring(fragmentIndex + 1) : null;
            return new URI(scheme, ssp, fragment);
        }
        return new URI(value2);
    }

    public String getAsText() {
        URI value2 = (URI)this.getValue();
        return value2 != null ? value2.toString() : "";
    }
}

