/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cache.annotation.AnnotationCacheOperationSource;
import org.springframework.cache.config.CacheNamespaceHandler;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheInterceptor;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.cache.interceptor.NameMatchCacheOperationSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheAdviceParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CACHEABLE_ELEMENT = "cacheable";
    private static final String CACHE_EVICT_ELEMENT = "cache-evict";
    private static final String CACHE_PUT_ELEMENT = "cache-put";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String DEFS_ELEMENT = "caching";

    CacheAdviceParser() {
    }

    @Override
    protected Class<?> getBeanClass(Element element2) {
        return CacheInterceptor.class;
    }

    @Override
    protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addPropertyReference("cacheManager", CacheNamespaceHandler.extractCacheManager(element2));
        CacheNamespaceHandler.parseKeyGenerator(element2, builder.getBeanDefinition());
        List<Element> cacheDefs = DomUtils.getChildElementsByTagName(element2, DEFS_ELEMENT);
        if (cacheDefs.size() >= 1) {
            List<RootBeanDefinition> attributeSourceDefinitions = this.parseDefinitionsSources(cacheDefs, parserContext);
            builder.addPropertyValue("cacheOperationSources", attributeSourceDefinitions);
        } else {
            builder.addPropertyValue("cacheOperationSources", new RootBeanDefinition(AnnotationCacheOperationSource.class));
        }
    }

    private List<RootBeanDefinition> parseDefinitionsSources(List<Element> definitions, ParserContext parserContext) {
        ManagedList<RootBeanDefinition> defs = new ManagedList<RootBeanDefinition>(definitions.size());
        for (Element element2 : definitions) {
            defs.add(this.parseDefinitionSource(element2, parserContext));
        }
        return defs;
    }

    private RootBeanDefinition parseDefinitionSource(Element definition, ParserContext parserContext) {
        Props prop2 = new Props(definition);
        ManagedMap<TypedStringValue, ArrayList<CacheOperation>> cacheOpMap = new ManagedMap<TypedStringValue, ArrayList<CacheOperation>>();
        cacheOpMap.setSource(parserContext.extractSource(definition));
        List<Element> cacheableCacheMethods = DomUtils.getChildElementsByTagName(definition, CACHEABLE_ELEMENT);
        for (Element opElement : cacheableCacheMethods) {
            String name = prop2.merge(opElement, parserContext.getReaderContext());
            TypedStringValue nameHolder = new TypedStringValue(name);
            nameHolder.setSource(parserContext.extractSource(opElement));
            CacheableOperation op = prop2.merge(opElement, parserContext.getReaderContext(), new CacheableOperation());
            ArrayList<CacheableOperation> col = (ArrayList<CacheableOperation>)cacheOpMap.get(nameHolder);
            if (col == null) {
                col = new ArrayList<CacheableOperation>(2);
                cacheOpMap.put(nameHolder, col);
            }
            col.add(op);
        }
        List<Element> evictCacheMethods = DomUtils.getChildElementsByTagName(definition, CACHE_EVICT_ELEMENT);
        for (Element opElement : evictCacheMethods) {
            ArrayList<CacheEvictOperation> col;
            String after2;
            String name = prop2.merge(opElement, parserContext.getReaderContext());
            TypedStringValue nameHolder = new TypedStringValue(name);
            nameHolder.setSource(parserContext.extractSource(opElement));
            CacheEvictOperation op = prop2.merge(opElement, parserContext.getReaderContext(), new CacheEvictOperation());
            String wide = opElement.getAttribute("all-entries");
            if (StringUtils.hasText(wide)) {
                op.setCacheWide(Boolean.valueOf(wide.trim()));
            }
            if (StringUtils.hasText(after2 = opElement.getAttribute("before-invocation"))) {
                op.setBeforeInvocation(Boolean.valueOf(after2.trim()));
            }
            if ((col = (ArrayList<CacheEvictOperation>)cacheOpMap.get(nameHolder)) == null) {
                col = new ArrayList<CacheEvictOperation>(2);
                cacheOpMap.put(nameHolder, col);
            }
            col.add(op);
        }
        List<Element> putCacheMethods = DomUtils.getChildElementsByTagName(definition, CACHE_PUT_ELEMENT);
        for (Element opElement : putCacheMethods) {
            String name = prop2.merge(opElement, parserContext.getReaderContext());
            TypedStringValue nameHolder = new TypedStringValue(name);
            nameHolder.setSource(parserContext.extractSource(opElement));
            CachePutOperation op = prop2.merge(opElement, parserContext.getReaderContext(), new CachePutOperation());
            ArrayList<CachePutOperation> col = (ArrayList<CachePutOperation>)cacheOpMap.get(nameHolder);
            if (col == null) {
                col = new ArrayList<CachePutOperation>(2);
                cacheOpMap.put(nameHolder, col);
            }
            col.add(op);
        }
        RootBeanDefinition attributeSourceDefinition = new RootBeanDefinition(NameMatchCacheOperationSource.class);
        attributeSourceDefinition.setSource(parserContext.extractSource(definition));
        attributeSourceDefinition.getPropertyValues().add("nameMap", cacheOpMap);
        return attributeSourceDefinition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Props {
        private String key;
        private String condition;
        private String method;
        private String[] caches = null;

        Props(Element root2) {
            String defaultCache = root2.getAttribute("cache");
            this.key = root2.getAttribute("key");
            this.condition = root2.getAttribute("condition");
            this.method = root2.getAttribute(CacheAdviceParser.METHOD_ATTRIBUTE);
            if (StringUtils.hasText(defaultCache)) {
                this.caches = StringUtils.commaDelimitedListToStringArray(defaultCache.trim());
            }
        }

        <T extends CacheOperation> T merge(Element element2, ReaderContext readerCtx, T op) {
            String cache = element2.getAttribute("cache");
            String k = element2.getAttribute("key");
            String c2 = element2.getAttribute("condition");
            String[] localCaches = this.caches;
            String localKey = this.key;
            String localCondition = this.condition;
            if (StringUtils.hasText(cache)) {
                localCaches = StringUtils.commaDelimitedListToStringArray(cache.trim());
            } else if (this.caches == null) {
                readerCtx.error("No cache specified specified for " + element2.getNodeName(), element2);
            }
            if (StringUtils.hasText(k)) {
                localKey = k.trim();
            }
            if (StringUtils.hasText(c2)) {
                localCondition = c2.trim();
            }
            op.setCacheNames(localCaches);
            op.setKey(localKey);
            op.setCondition(localCondition);
            return op;
        }

        String merge(Element element2, ReaderContext readerCtx) {
            String m = element2.getAttribute(CacheAdviceParser.METHOD_ATTRIBUTE);
            if (StringUtils.hasText(m)) {
                return m.trim();
            }
            if (StringUtils.hasText(this.method)) {
                return this.method;
            }
            readerCtx.error("No method specified for " + element2.getNodeName(), element2);
            return null;
        }
    }
}

