/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.cache.interceptor.CacheAspectSupport;

public class CacheInterceptor
extends CacheAspectSupport
implements MethodInterceptor,
Serializable {
    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        CacheAspectSupport.Invoker aopAllianceInvoker = new CacheAspectSupport.Invoker(){

            public Object invoke() {
                try {
                    return invocation.proceed();
                }
                catch (Throwable ex2) {
                    throw new ThrowableWrapper(ex2);
                }
            }
        };
        try {
            return this.execute(aopAllianceInvoker, invocation.getThis(), method, invocation.getArguments());
        }
        catch (ThrowableWrapper th2) {
            throw th2.original;
        }
    }

    private static class ThrowableWrapper
    extends RuntimeException {
        private final Throwable original;

        ThrowableWrapper(Throwable original) {
            this.original = original;
        }
    }
}

