/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCacheOperationSource
implements CacheOperationSource,
Serializable {
    private final CacheOperationSource[] cacheOperationSources;

    public CompositeCacheOperationSource(CacheOperationSource ... cacheOperationSources) {
        Assert.notEmpty(cacheOperationSources, "cacheOperationSources array must not be empty");
        this.cacheOperationSources = cacheOperationSources;
    }

    public final CacheOperationSource[] getCacheOperationSources() {
        return this.cacheOperationSources;
    }

    @Override
    public Collection<CacheOperation> getCacheOperations(Method method, Class<?> targetClass) {
        ArrayList<CacheOperation> ops2 = null;
        CacheOperationSource[] cacheOperationSourceArray = this.cacheOperationSources;
        int n = this.cacheOperationSources.length;
        int n2 = 0;
        while (n2 < n) {
            CacheOperationSource source = cacheOperationSourceArray[n2];
            Collection<CacheOperation> cacheOperations = source.getCacheOperations(method, targetClass);
            if (cacheOperations != null) {
                if (ops2 == null) {
                    ops2 = new ArrayList<CacheOperation>();
                }
                ops2.addAll(cacheOperations);
            }
            ++n2;
        }
        return ops2;
    }
}

