/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoOpCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private Set<String> names = new LinkedHashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name) {
        Cache cache = (Cache)this.caches.get(name);
        if (cache == null) {
            this.caches.putIfAbsent(name, new NoOpCache(name));
            Set<String> set2 = this.names;
            synchronized (set2) {
                this.names.add(name);
            }
        }
        return (Cache)this.caches.get(name);
    }

    @Override
    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.names);
    }

    private static class NoOpCache
    implements Cache {
        private final String name;

        public NoOpCache(String name) {
            this.name = name;
        }

        public void clear() {
        }

        public void evict(Object key) {
        }

        public Cache.ValueWrapper get(Object key) {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public Object getNativeCache() {
            return null;
        }

        public void put(Object key, Object value2) {
        }
    }
}

