/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.annotation.Annotation;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.MetadataUtils;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdviceModeImportSelector<A extends Annotation>
implements ImportSelector {
    public static final String DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME = "mode";

    protected String getAdviceModeAttributeName() {
        return DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME;
    }

    @Override
    public final String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Class<?> annoType = GenericTypeResolver.resolveTypeArgument(this.getClass(), AdviceModeImportSelector.class);
        AnnotationAttributes attributes2 = MetadataUtils.attributesFor(importingClassMetadata, annoType);
        Assert.notNull(attributes2, String.format("@%s is not present on importing class '%s' as expected", annoType.getSimpleName(), importingClassMetadata.getClassName()));
        AdviceMode adviceMode = (AdviceMode)((Object)attributes2.getEnum(this.getAdviceModeAttributeName()));
        String[] imports = this.selectImports(adviceMode);
        Assert.notNull(imports, String.format("Unknown AdviceMode: '%s'", new Object[]{adviceMode}));
        return imports;
    }

    protected abstract String[] selectImports(AdviceMode var1);
}

