/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanAnnotationHelper;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.MetadataUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyCreator;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassBeanDefinitionReader {
    private static final Log logger = LogFactory.getLog(ConfigurationClassBeanDefinitionReader.class);
    private final BeanDefinitionRegistry registry;
    private final SourceExtractor sourceExtractor;
    private final ProblemReporter problemReporter;
    private final MetadataReaderFactory metadataReaderFactory;
    private final ResourceLoader resourceLoader;
    private final Environment environment;
    private final BeanNameGenerator beanNameGenerator;

    public ConfigurationClassBeanDefinitionReader(BeanDefinitionRegistry registry, SourceExtractor sourceExtractor, ProblemReporter problemReporter, MetadataReaderFactory metadataReaderFactory, ResourceLoader resourceLoader, Environment environment, BeanNameGenerator beanNameGenerator) {
        Assert.notNull(beanNameGenerator, "BeanNameGenerator must not be null");
        this.registry = registry;
        this.sourceExtractor = sourceExtractor;
        this.problemReporter = problemReporter;
        this.metadataReaderFactory = metadataReaderFactory;
        this.resourceLoader = resourceLoader;
        this.environment = environment;
        this.beanNameGenerator = beanNameGenerator;
    }

    public void loadBeanDefinitions(Set<ConfigurationClass> configurationModel) {
        for (ConfigurationClass configClass : configurationModel) {
            this.loadBeanDefinitionsForConfigurationClass(configClass);
        }
    }

    private void loadBeanDefinitionsForConfigurationClass(ConfigurationClass configClass) {
        this.doLoadBeanDefinitionForConfigurationClassIfNecessary(configClass);
        for (BeanMethod beanMethod : configClass.getBeanMethods()) {
            this.loadBeanDefinitionsForBeanMethod(beanMethod);
        }
        this.loadBeanDefinitionsFromImportedResources(configClass.getImportedResources());
    }

    private void doLoadBeanDefinitionForConfigurationClassIfNecessary(ConfigurationClass configClass) {
        if (!configClass.isImported()) {
            return;
        }
        AnnotationMetadata metadata = configClass.getMetadata();
        AnnotatedGenericBeanDefinition configBeanDef = new AnnotatedGenericBeanDefinition(metadata);
        String className = metadata.getClassName();
        configBeanDef.setBeanClassName(className);
        if (ConfigurationClassUtils.checkConfigurationClassCandidate(configBeanDef, this.metadataReaderFactory)) {
            String configBeanName = this.beanNameGenerator.generateBeanName(configBeanDef, this.registry);
            this.registry.registerBeanDefinition(configBeanName, configBeanDef);
            configClass.setBeanName(configBeanName);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Registered bean definition for imported @Configuration class %s", configBeanName));
            }
        } else {
            this.problemReporter.error(new InvalidConfigurationImportProblem(className, configClass.getResource(), metadata));
        }
    }

    private void loadBeanDefinitionsForBeanMethod(BeanMethod beanMethod) {
        String destroyMethodName;
        String initMethodName;
        Autowire autowire;
        AnnotationAttributes dependsOn2;
        String[] otherBeans;
        AnnotationAttributes lazy;
        BeanDefinition existingBeanDef;
        AnnotationAttributes bean;
        ArrayList names;
        ConfigurationClass configClass = beanMethod.getConfigurationClass();
        MethodMetadata metadata = beanMethod.getMetadata();
        ConfigurationClassBeanDefinition beanDef = new ConfigurationClassBeanDefinition(configClass);
        beanDef.setResource(configClass.getResource());
        beanDef.setSource(this.sourceExtractor.extractSource(metadata, configClass.getResource()));
        if (metadata.isStatic()) {
            beanDef.setBeanClassName(configClass.getMetadata().getClassName());
            beanDef.setFactoryMethodName(metadata.getMethodName());
        } else {
            beanDef.setFactoryBeanName(configClass.getBeanName());
            beanDef.setUniqueFactoryMethodName(metadata.getMethodName());
        }
        beanDef.setAutowireMode(3);
        beanDef.setAttribute(RequiredAnnotationBeanPostProcessor.SKIP_REQUIRED_CHECK_ATTRIBUTE, Boolean.TRUE);
        AnnotationAttributes role = MetadataUtils.attributesFor(metadata, Role.class);
        if (role != null) {
            beanDef.setRole((Integer)role.getNumber("value"));
        }
        String beanName = (names = new ArrayList(Arrays.asList((bean = MetadataUtils.attributesFor(metadata, Bean.class)).getStringArray("name")))).size() > 0 ? (String)names.remove(0) : beanMethod.getMetadata().getMethodName();
        for (String alias : names) {
            this.registry.registerAlias(beanName, alias);
        }
        if (this.registry.containsBeanDefinition(beanName) && !((existingBeanDef = this.registry.getBeanDefinition(beanName)) instanceof ConfigurationClassBeanDefinition)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Skipping loading bean definition for %s: a definition for bean '%s' already exists. This is likely due to an override in XML.", beanMethod, beanName));
            }
            return;
        }
        if (metadata.isAnnotated(Primary.class.getName())) {
            beanDef.setPrimary(true);
        }
        if (metadata.isAnnotated(Lazy.class.getName())) {
            lazy = MetadataUtils.attributesFor(metadata, Lazy.class);
            beanDef.setLazyInit(lazy.getBoolean("value"));
        } else if (configClass.getMetadata().isAnnotated(Lazy.class.getName())) {
            lazy = MetadataUtils.attributesFor(configClass.getMetadata(), Lazy.class);
            beanDef.setLazyInit(lazy.getBoolean("value"));
        }
        if (metadata.isAnnotated(DependsOn.class.getName()) && (otherBeans = (dependsOn2 = MetadataUtils.attributesFor(metadata, DependsOn.class)).getStringArray("value")).length > 0) {
            beanDef.setDependsOn(otherBeans);
        }
        if ((autowire = (Autowire)((Object)bean.getEnum("autowire"))).isAutowire()) {
            beanDef.setAutowireMode(autowire.value());
        }
        if (StringUtils.hasText(initMethodName = bean.getString("initMethod"))) {
            beanDef.setInitMethodName(initMethodName);
        }
        if (StringUtils.hasText(destroyMethodName = bean.getString("destroyMethod"))) {
            beanDef.setDestroyMethodName(destroyMethodName);
        }
        ScopedProxyMode proxyMode = ScopedProxyMode.NO;
        AnnotationAttributes scope = MetadataUtils.attributesFor(metadata, Scope.class);
        if (scope != null) {
            beanDef.setScope(scope.getString("value"));
            proxyMode = (ScopedProxyMode)((Object)scope.getEnum("proxyMode"));
            if (proxyMode == ScopedProxyMode.DEFAULT) {
                proxyMode = ScopedProxyMode.NO;
            }
        }
        BeanDefinition beanDefToRegister = beanDef;
        if (proxyMode != ScopedProxyMode.NO) {
            BeanDefinitionHolder proxyDef = ScopedProxyCreator.createScopedProxy(new BeanDefinitionHolder(beanDef, beanName), this.registry, proxyMode == ScopedProxyMode.TARGET_CLASS);
            beanDefToRegister = proxyDef.getBeanDefinition();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Registering bean definition for @Bean method %s.%s()", configClass.getMetadata().getClassName(), beanName));
        }
        this.registry.registerBeanDefinition(beanName, beanDefToRegister);
    }

    private void loadBeanDefinitionsFromImportedResources(Map<String, Class<? extends BeanDefinitionReader>> importedResources) {
        HashMap<Class<? extends BeanDefinitionReader>, BeanDefinitionReader> readerInstanceCache = new HashMap<Class<? extends BeanDefinitionReader>, BeanDefinitionReader>();
        for (Map.Entry<String, Class<? extends BeanDefinitionReader>> entry2 : importedResources.entrySet()) {
            String resource = entry2.getKey();
            Class<? extends BeanDefinitionReader> readerClass = entry2.getValue();
            if (!readerInstanceCache.containsKey(readerClass)) {
                try {
                    BeanDefinitionReader readerInstance = readerClass.getConstructor(BeanDefinitionRegistry.class).newInstance(this.registry);
                    if (readerInstance instanceof AbstractBeanDefinitionReader) {
                        AbstractBeanDefinitionReader abdr = (AbstractBeanDefinitionReader)readerInstance;
                        abdr.setResourceLoader(this.resourceLoader);
                        abdr.setEnvironment(this.environment);
                    }
                    readerInstanceCache.put(readerClass, readerInstance);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Could not instantiate BeanDefinitionReader class [" + readerClass.getName() + "]");
                }
            }
            BeanDefinitionReader reader2 = (BeanDefinitionReader)readerInstanceCache.get(readerClass);
            reader2.loadBeanDefinitions(resource);
        }
    }

    private static class ConfigurationClassBeanDefinition
    extends RootBeanDefinition
    implements AnnotatedBeanDefinition {
        private AnnotationMetadata annotationMetadata;

        public ConfigurationClassBeanDefinition(ConfigurationClass configClass) {
            this.annotationMetadata = configClass.getMetadata();
        }

        private ConfigurationClassBeanDefinition(ConfigurationClassBeanDefinition original) {
            super(original);
            this.annotationMetadata = original.annotationMetadata;
        }

        public AnnotationMetadata getMetadata() {
            return this.annotationMetadata;
        }

        public boolean isFactoryMethod(Method candidate) {
            return super.isFactoryMethod(candidate) && BeanAnnotationHelper.isBeanAnnotated(candidate);
        }

        public ConfigurationClassBeanDefinition cloneBeanDefinition() {
            return new ConfigurationClassBeanDefinition(this);
        }
    }

    private static class InvalidConfigurationImportProblem
    extends Problem {
        public InvalidConfigurationImportProblem(String className, Resource resource, AnnotationMetadata metadata) {
            super(String.format("%s was @Import'ed but is not annotated with @Configuration nor does it declare any @Bean methods; it does not implement ImportSelector or extend ImportBeanDefinitionRegistrar. Update the class to meet one of these requirements or do not attempt to @Import it.", className), new Location(resource, metadata));
        }
    }
}

