/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScanAnnotationParser;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.MetadataUtils;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassParser {
    private final MetadataReaderFactory metadataReaderFactory;
    private final ProblemReporter problemReporter;
    private final ImportStack importStack = new ImportStack();
    private final Set<String> knownSuperclasses = new LinkedHashSet<String>();
    private final Set<ConfigurationClass> configurationClasses = new LinkedHashSet<ConfigurationClass>();
    private final Stack<org.springframework.core.env.PropertySource<?>> propertySources = new Stack();
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final BeanDefinitionRegistry registry;
    private final ComponentScanAnnotationParser componentScanParser;

    public ConfigurationClassParser(MetadataReaderFactory metadataReaderFactory, ProblemReporter problemReporter, Environment environment, ResourceLoader resourceLoader, BeanNameGenerator beanNameGenerator, BeanDefinitionRegistry registry) {
        this.metadataReaderFactory = metadataReaderFactory;
        this.problemReporter = problemReporter;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.registry = registry;
        this.componentScanParser = new ComponentScanAnnotationParser(resourceLoader, environment, beanNameGenerator, registry);
    }

    public void parse(String className, String beanName) throws IOException {
        MetadataReader reader2 = this.metadataReaderFactory.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader2, beanName));
    }

    public void parse(Class<?> clazz2, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(clazz2, beanName));
    }

    protected void processConfigurationClass(ConfigurationClass configClass) throws IOException {
        AnnotationAttributes profile;
        AnnotationMetadata metadata = configClass.getMetadata();
        if (this.environment != null && metadata.isAnnotated(Profile.class.getName()) && !this.environment.acceptsProfiles((profile = MetadataUtils.attributesFor(metadata, Profile.class)).getStringArray("value"))) {
            return;
        }
        while ((metadata = this.doProcessConfigurationClass(configClass, metadata)) != null) {
        }
        if (this.configurationClasses.contains(configClass) && configClass.getBeanName() != null) {
            this.configurationClasses.remove(configClass);
        }
        this.configurationClasses.add(configClass);
    }

    protected AnnotationMetadata doProcessConfigurationClass(ConfigurationClass configClass, AnnotationMetadata metadata) throws IOException {
        String superclass;
        AnnotationAttributes componentScan;
        String[] stringArray;
        int n;
        String[] stringArray2 = metadata.getMemberClassNames();
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            String memberClassName = stringArray2[n3];
            MetadataReader reader2 = this.metadataReaderFactory.getMetadataReader(memberClassName);
            AnnotationMetadata memberClassMetadata = reader2.getAnnotationMetadata();
            if (ConfigurationClassUtils.isConfigurationCandidate(memberClassMetadata)) {
                this.processConfigurationClass(new ConfigurationClass(reader2, true));
            }
            ++n3;
        }
        AnnotationAttributes propertySource = MetadataUtils.attributesFor(metadata, PropertySource.class);
        if (propertySource != null) {
            String name = propertySource.getString("name");
            String[] locations = propertySource.getStringArray("value");
            int nLocations = locations.length;
            if (nLocations == 0) {
                throw new IllegalArgumentException("At least one @PropertySource(value) location is required");
            }
            int i = 0;
            while (i < nLocations) {
                locations[0] = this.environment.resolveRequiredPlaceholders(locations[0]);
                ++i;
            }
            ClassLoader classLoader = this.resourceLoader.getClassLoader();
            if (!StringUtils.hasText(name)) {
                String[] stringArray3 = locations;
                n = locations.length;
                int n4 = 0;
                while (n4 < n) {
                    String location2 = stringArray3[n4];
                    this.propertySources.push(new ResourcePropertySource(location2, classLoader));
                    ++n4;
                }
            } else if (nLocations == 1) {
                this.propertySources.push(new ResourcePropertySource(name, locations[0], classLoader));
            } else {
                CompositePropertySource ps = new CompositePropertySource(name);
                stringArray = locations;
                int n5 = locations.length;
                n = 0;
                while (n < n5) {
                    String location3 = stringArray[n];
                    ps.addPropertySource(new ResourcePropertySource(location3, classLoader));
                    ++n;
                }
                this.propertySources.push(ps);
            }
        }
        if ((componentScan = MetadataUtils.attributesFor(metadata, ComponentScan.class)) != null) {
            Set<BeanDefinitionHolder> scannedBeanDefinitions = this.componentScanParser.parse(componentScan);
            for (BeanDefinitionHolder holder : scannedBeanDefinitions) {
                if (!ConfigurationClassUtils.checkConfigurationClassCandidate(holder.getBeanDefinition(), this.metadataReaderFactory)) continue;
                this.parse(holder.getBeanDefinition().getBeanClassName(), holder.getBeanName());
            }
        }
        List<AnnotationAttributes> imports = this.findAllAnnotationAttributes(Import.class, metadata.getClassName(), true);
        for (AnnotationAttributes importAnno : imports) {
            this.processImport(configClass, importAnno.getStringArray("value"), true);
        }
        if (metadata.isAnnotated(ImportResource.class.getName())) {
            AnnotationAttributes importResource = MetadataUtils.attributesFor(metadata, ImportResource.class);
            String[] resources = importResource.getStringArray("value");
            Class readerClass = importResource.getClass("reader");
            stringArray = resources;
            int n6 = resources.length;
            n = 0;
            while (n < n6) {
                String resource = stringArray[n];
                configClass.addImportedResource(resource, readerClass);
                ++n;
            }
        }
        Set<MethodMetadata> beanMethods = metadata.getAnnotatedMethods(Bean.class.getName());
        for (MethodMetadata methodMetadata : beanMethods) {
            configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
        }
        if (metadata.hasSuperClass() && this.knownSuperclasses.add(superclass = metadata.getSuperClassName())) {
            if (metadata instanceof StandardAnnotationMetadata) {
                Class clazz2 = ((StandardAnnotationMetadata)metadata).getIntrospectedClass();
                return new StandardAnnotationMetadata(clazz2.getSuperclass(), true);
            }
            MetadataReader reader3 = this.metadataReaderFactory.getMetadataReader(superclass);
            return reader3.getAnnotationMetadata();
        }
        return null;
    }

    private List<AnnotationAttributes> findAllAnnotationAttributes(Class<? extends Annotation> targetAnnotation, String annotatedClassName, boolean classValuesAsString) throws IOException {
        ArrayList<AnnotationAttributes> allAttribs = new ArrayList<AnnotationAttributes>();
        MetadataReader reader2 = this.metadataReaderFactory.getMetadataReader(annotatedClassName);
        AnnotationMetadata metadata = reader2.getAnnotationMetadata();
        String targetAnnotationType = targetAnnotation.getName();
        for (String annotationType : metadata.getAnnotationTypes()) {
            AnnotationMetadata metaAnnotations;
            AnnotationAttributes targetAttribs;
            if (annotationType.equals(targetAnnotationType) || (targetAttribs = AnnotationAttributes.fromMap((metaAnnotations = this.metadataReaderFactory.getMetadataReader(annotationType).getAnnotationMetadata()).getAnnotationAttributes(targetAnnotationType, classValuesAsString))) == null) continue;
            allAttribs.add(targetAttribs);
        }
        AnnotationAttributes localAttribs = AnnotationAttributes.fromMap(metadata.getAnnotationAttributes(targetAnnotationType, classValuesAsString));
        if (localAttribs != null) {
            allAttribs.add(localAttribs);
        }
        return allAttribs;
    }

    private void processImport(ConfigurationClass configClass, String[] classesToImport, boolean checkForCircularImports) throws IOException {
        if (checkForCircularImports && this.importStack.contains(configClass)) {
            this.problemReporter.error(new CircularImportProblem(configClass, this.importStack, configClass.getMetadata()));
        } else {
            this.importStack.push(configClass);
            AnnotationMetadata importingClassMetadata = configClass.getMetadata();
            String[] stringArray = classesToImport;
            int n = classesToImport.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate = stringArray[n2];
                MetadataReader reader2 = this.metadataReaderFactory.getMetadataReader(candidate);
                if (new AssignableTypeFilter(ImportSelector.class).match(reader2, this.metadataReaderFactory)) {
                    try {
                        ImportSelector selector = BeanUtils.instantiateClass(Class.forName(candidate), ImportSelector.class);
                        this.processImport(configClass, selector.selectImports(importingClassMetadata), false);
                    }
                    catch (ClassNotFoundException ex2) {
                        throw new IllegalStateException(ex2);
                    }
                } else if (new AssignableTypeFilter(ImportBeanDefinitionRegistrar.class).match(reader2, this.metadataReaderFactory)) {
                    try {
                        ImportBeanDefinitionRegistrar registrar = BeanUtils.instantiateClass(Class.forName(candidate), ImportBeanDefinitionRegistrar.class);
                        registrar.registerBeanDefinitions(importingClassMetadata, this.registry);
                    }
                    catch (ClassNotFoundException ex3) {
                        throw new IllegalStateException(ex3);
                    }
                } else {
                    this.importStack.registerImport(importingClassMetadata.getClassName(), candidate);
                    this.processConfigurationClass(new ConfigurationClass(reader2, true));
                }
                ++n2;
            }
            this.importStack.pop();
        }
    }

    public void validate() {
        for (ConfigurationClass configClass : this.configurationClasses) {
            configClass.validate(this.problemReporter);
        }
    }

    public Set<ConfigurationClass> getConfigurationClasses() {
        return this.configurationClasses;
    }

    public Stack<org.springframework.core.env.PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    public ImportRegistry getImportRegistry() {
        return this.importStack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Stack<ConfigurationClass> importStack, AnnotationMetadata metadata) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack [%s]", importStack.peek().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.peek().getResource(), metadata));
        }
    }

    static interface ImportRegistry {
        public String getImportingClassFor(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportStack
    extends Stack<ConfigurationClass>
    implements ImportRegistry {
        private Map<String, String> imports = new HashMap<String, String>();

        private ImportStack() {
        }

        @Override
        public String getImportingClassFor(String importedClass) {
            return this.imports.get(importedClass);
        }

        public void registerImport(String importingClass, String importedClass) {
            this.imports.put(importedClass, importingClass);
        }

        @Override
        public boolean contains(Object elem2) {
            ConfigurationClass configClass = (ConfigurationClass)elem2;
            Comparator<ConfigurationClass> comparator = new Comparator<ConfigurationClass>(){

                @Override
                public int compare(ConfigurationClass first2, ConfigurationClass second2) {
                    return first2.getMetadata().getClassName().equals(second2.getMetadata().getClassName()) ? 0 : 1;
                }
            };
            return Collections.binarySearch(this, configClass, comparator) != -1;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("ImportStack: [");
            Iterator iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                builder.append(((ConfigurationClass)iterator2.next()).getSimpleName());
                if (!iterator2.hasNext()) continue;
                builder.append("->");
            }
            return builder.append(']').toString();
        }
    }
}

