/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jmx.support.MBeanServerFactoryBean;
import org.springframework.jmx.support.WebSphereMBeanServerFactoryBean;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class MBeanServerBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String MBEAN_SERVER_BEAN_NAME = "mbeanServer";
    private static final String AGENT_ID_ATTRIBUTE = "agent-id";
    private static final boolean weblogicPresent = ClassUtils.isPresent("weblogic.management.Helper", MBeanServerBeanDefinitionParser.class.getClassLoader());
    private static final boolean webspherePresent = ClassUtils.isPresent("com.ibm.websphere.management.AdminServiceFactory", MBeanServerBeanDefinitionParser.class.getClassLoader());

    MBeanServerBeanDefinitionParser() {
    }

    protected String resolveId(Element element2, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id2 = element2.getAttribute("id");
        return StringUtils.hasText(id2) ? id2 : MBEAN_SERVER_BEAN_NAME;
    }

    protected AbstractBeanDefinition parseInternal(Element element2, ParserContext parserContext) {
        String agentId = element2.getAttribute(AGENT_ID_ATTRIBUTE);
        if (StringUtils.hasText(agentId)) {
            RootBeanDefinition bd = new RootBeanDefinition(MBeanServerFactoryBean.class);
            bd.getPropertyValues().add("agentId", agentId);
            return bd;
        }
        AbstractBeanDefinition specialServer = MBeanServerBeanDefinitionParser.findServerForSpecialEnvironment();
        if (specialServer != null) {
            return specialServer;
        }
        RootBeanDefinition bd = new RootBeanDefinition(MBeanServerFactoryBean.class);
        bd.getPropertyValues().add("locateExistingServerIfPossible", Boolean.TRUE);
        bd.setRole(2);
        bd.setSource(parserContext.extractSource(element2));
        return bd;
    }

    static AbstractBeanDefinition findServerForSpecialEnvironment() {
        if (weblogicPresent) {
            RootBeanDefinition bd = new RootBeanDefinition(JndiObjectFactoryBean.class);
            bd.getPropertyValues().add("jndiName", "java:comp/env/jmx/runtime");
            return bd;
        }
        if (webspherePresent) {
            return new RootBeanDefinition(WebSphereMBeanServerFactoryBean.class);
        }
        return null;
    }
}

