/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.util.Map;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

public class MapAccessor
implements PropertyAccessor {
    public boolean canRead(EvaluationContext context, Object target2, String name) throws AccessException {
        Map map3 = (Map)target2;
        return map3.containsKey(name);
    }

    public TypedValue read(EvaluationContext context, Object target2, String name) throws AccessException {
        Map map3 = (Map)target2;
        Object value2 = map3.get(name);
        if (value2 == null && !map3.containsKey(name)) {
            throw new MapAccessException(name);
        }
        return new TypedValue(value2);
    }

    public boolean canWrite(EvaluationContext context, Object target2, String name) throws AccessException {
        return true;
    }

    public void write(EvaluationContext context, Object target2, String name, Object newValue) throws AccessException {
        Map map3 = (Map)target2;
        map3.put(name, newValue);
    }

    public Class[] getSpecificTargetClasses() {
        return new Class[]{Map.class};
    }

    private static class MapAccessException
    extends AccessException {
        private final String key;

        public MapAccessException(String key) {
            super((String)null);
            this.key = key;
        }

        public String getMessage() {
            return "Map does not contain a value for key '" + this.key + "'";
        }
    }
}

