/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ClassPathXmlApplicationContext
extends AbstractXmlApplicationContext {
    private Resource[] configResources;

    public ClassPathXmlApplicationContext() {
    }

    public ClassPathXmlApplicationContext(ApplicationContext parent2) {
        super(parent2);
    }

    public ClassPathXmlApplicationContext(String configLocation) throws BeansException {
        this(new String[]{configLocation}, true, null);
    }

    public ClassPathXmlApplicationContext(String ... configLocations) throws BeansException {
        this(configLocations, true, null);
    }

    public ClassPathXmlApplicationContext(String[] configLocations, ApplicationContext parent2) throws BeansException {
        this(configLocations, true, parent2);
    }

    public ClassPathXmlApplicationContext(String[] configLocations, boolean refresh2) throws BeansException {
        this(configLocations, refresh2, null);
    }

    public ClassPathXmlApplicationContext(String[] configLocations, boolean refresh2, ApplicationContext parent2) throws BeansException {
        super(parent2);
        this.setConfigLocations(configLocations);
        if (refresh2) {
            this.refresh();
        }
    }

    public ClassPathXmlApplicationContext(String path2, Class clazz2) throws BeansException {
        this(new String[]{path2}, clazz2);
    }

    public ClassPathXmlApplicationContext(String[] paths, Class clazz2) throws BeansException {
        this(paths, clazz2, null);
    }

    public ClassPathXmlApplicationContext(String[] paths, Class clazz2, ApplicationContext parent2) throws BeansException {
        super(parent2);
        Assert.notNull(paths, "Path array must not be null");
        Assert.notNull(clazz2, "Class argument must not be null");
        this.configResources = new Resource[paths.length];
        int i = 0;
        while (i < paths.length) {
            this.configResources[i] = new ClassPathResource(paths[i], clazz2);
            ++i;
        }
        this.refresh();
    }

    protected Resource[] getConfigResources() {
        return this.configResources;
    }
}

