/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.core.OverridingClassLoader;
import org.springframework.core.SmartClassLoader;
import org.springframework.util.ReflectionUtils;

class ContextTypeMatchClassLoader
extends DecoratingClassLoader
implements SmartClassLoader {
    private static Method findLoadedClassMethod;
    private final Map<String, byte[]> bytesCache = new HashMap<String, byte[]>();

    static {
        try {
            findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("Invalid [java.lang.ClassLoader] class: no 'findLoadedClass' method defined!");
        }
    }

    public ContextTypeMatchClassLoader(ClassLoader parent2) {
        super(parent2);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return new ContextOverridingClassLoader(this.getParent()).loadClass(name);
    }

    public boolean isClassReloadable(Class clazz2) {
        return clazz2.getClassLoader() instanceof ContextOverridingClassLoader;
    }

    private class ContextOverridingClassLoader
    extends OverridingClassLoader {
        public ContextOverridingClassLoader(ClassLoader parent2) {
            super(parent2);
        }

        protected boolean isEligibleForOverriding(String className) {
            if (this.isExcluded(className) || ContextTypeMatchClassLoader.this.isExcluded(className)) {
                return false;
            }
            ReflectionUtils.makeAccessible(findLoadedClassMethod);
            ClassLoader parent2 = this.getParent();
            while (parent2 != null) {
                if (ReflectionUtils.invokeMethod(findLoadedClassMethod, parent2, className) != null) {
                    return false;
                }
                parent2 = parent2.getParent();
            }
            return true;
        }

        protected Class loadClassForOverriding(String name) throws ClassNotFoundException {
            byte[] bytes2 = (byte[])ContextTypeMatchClassLoader.this.bytesCache.get(name);
            if (bytes2 == null) {
                bytes2 = this.loadBytesForClass(name);
                if (bytes2 != null) {
                    ContextTypeMatchClassLoader.this.bytesCache.put(name, bytes2);
                } else {
                    return null;
                }
            }
            return this.defineClass(name, bytes2, 0, bytes2.length);
        }
    }
}

