/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceSupport;

public class DelegatingMessageSource
extends MessageSourceSupport
implements HierarchicalMessageSource {
    private MessageSource parentMessageSource;

    public void setParentMessageSource(MessageSource parent2) {
        this.parentMessageSource = parent2;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public String getMessage(String code2, Object[] args2, String defaultMessage, Locale locale) {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(code2, args2, defaultMessage, locale);
        }
        return this.renderDefaultMessage(defaultMessage, args2, locale);
    }

    public String getMessage(String code2, Object[] args2, Locale locale) throws NoSuchMessageException {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(code2, args2, locale);
        }
        throw new NoSuchMessageException(code2, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(resolvable, locale);
        }
        if (resolvable.getDefaultMessage() != null) {
            return this.renderDefaultMessage(resolvable.getDefaultMessage(), resolvable.getArguments(), locale);
        }
        String[] codes = resolvable.getCodes();
        String code2 = codes != null && codes.length > 0 ? codes[0] : null;
        throw new NoSuchMessageException(code2, locale);
    }
}

