/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadableResourceBundleMessageSource
extends AbstractMessageSource
implements ResourceLoaderAware {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    private String[] basenames = new String[0];
    private String defaultEncoding;
    private Properties fileEncodings;
    private boolean fallbackToSystemLocale = true;
    private long cacheMillis = -1L;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final Map<String, Map<Locale, List<String>>> cachedFilenames = new HashMap<String, Map<Locale, List<String>>>();
    private final Map<String, PropertiesHolder> cachedProperties = new HashMap<String, PropertiesHolder>();
    private final Map<Locale, PropertiesHolder> cachedMergedProperties = new HashMap<Locale, PropertiesHolder>();

    public void setBasename(String basename) {
        this.setBasenames(basename);
    }

    public void setBasenames(String ... basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            int i = 0;
            while (i < basenames.length) {
                String basename = basenames[i];
                Assert.hasText(basename, "Basename must not be empty");
                this.basenames[i] = basename.trim();
                ++i;
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setFileEncodings(Properties fileEncodings) {
        this.fileEncodings = fileEncodings;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = cacheSeconds * 1000;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    @Override
    protected String resolveCodeWithoutArguments(String code2, Locale locale) {
        if (this.cacheMillis < 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            String result2 = propHolder.getProperty(code2);
            if (result2 != null) {
                return result2;
            }
        } else {
            String[] stringArray = this.basenames;
            int n = this.basenames.length;
            int n2 = 0;
            while (n2 < n) {
                String basename = stringArray[n2];
                List<String> filenames = this.calculateAllFilenames(basename, locale);
                for (String filename : filenames) {
                    PropertiesHolder propHolder = this.getProperties(filename);
                    String result3 = propHolder.getProperty(code2);
                    if (result3 == null) continue;
                    return result3;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    protected MessageFormat resolveCode(String code2, Locale locale) {
        if (this.cacheMillis < 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            MessageFormat result2 = propHolder.getMessageFormat(code2, locale);
            if (result2 != null) {
                return result2;
            }
        } else {
            String[] stringArray = this.basenames;
            int n = this.basenames.length;
            int n2 = 0;
            while (n2 < n) {
                String basename = stringArray[n2];
                List<String> filenames = this.calculateAllFilenames(basename, locale);
                for (String filename : filenames) {
                    PropertiesHolder propHolder = this.getProperties(filename);
                    MessageFormat result3 = propHolder.getMessageFormat(code2, locale);
                    if (result3 == null) continue;
                    return result3;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getMergedProperties(Locale locale) {
        Map<Locale, PropertiesHolder> map3 = this.cachedMergedProperties;
        synchronized (map3) {
            PropertiesHolder mergedHolder = this.cachedMergedProperties.get(locale);
            if (mergedHolder != null) {
                return mergedHolder;
            }
            Properties mergedProps = new Properties();
            mergedHolder = new PropertiesHolder(mergedProps, -1L);
            int i = this.basenames.length - 1;
            while (i >= 0) {
                List<String> filenames = this.calculateAllFilenames(this.basenames[i], locale);
                int j = filenames.size() - 1;
                while (j >= 0) {
                    String filename = filenames.get(j);
                    PropertiesHolder propHolder = this.getProperties(filename);
                    if (propHolder.getProperties() != null) {
                        mergedProps.putAll((Map<?, ?>)propHolder.getProperties());
                    }
                    --j;
                }
                --i;
            }
            this.cachedMergedProperties.put(locale, mergedHolder);
            return mergedHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> calculateAllFilenames(String basename, Locale locale) {
        Map<String, Map<Locale, List<String>>> map3 = this.cachedFilenames;
        synchronized (map3) {
            List<String> filenames;
            Map<Locale, List<String>> localeMap = this.cachedFilenames.get(basename);
            if (localeMap != null && (filenames = localeMap.get(locale)) != null) {
                return filenames;
            }
            filenames = new ArrayList<String>(7);
            filenames.addAll(this.calculateFilenamesForLocale(basename, locale));
            if (this.fallbackToSystemLocale && !locale.equals(Locale.getDefault())) {
                List<String> fallbackFilenames = this.calculateFilenamesForLocale(basename, Locale.getDefault());
                for (String fallbackFilename : fallbackFilenames) {
                    if (filenames.contains(fallbackFilename)) continue;
                    filenames.add(fallbackFilename);
                }
            }
            filenames.add(basename);
            if (localeMap != null) {
                localeMap.put(locale, filenames);
            } else {
                localeMap = new HashMap<Locale, List<String>>();
                localeMap.put(locale, filenames);
                this.cachedFilenames.put(basename, localeMap);
            }
            return filenames;
        }
    }

    protected List<String> calculateFilenamesForLocale(String basename, Locale locale) {
        ArrayList<String> result2 = new ArrayList<String>(3);
        String language2 = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(basename);
        temp.append('_');
        if (language2.length() > 0) {
            temp.append(language2);
            result2.add(0, temp.toString());
        }
        temp.append('_');
        if (country.length() > 0) {
            temp.append(country);
            result2.add(0, temp.toString());
        }
        if (variant.length() > 0 && (language2.length() > 0 || country.length() > 0)) {
            temp.append('_').append(variant);
            result2.add(0, temp.toString());
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getProperties(String filename) {
        Map<String, PropertiesHolder> map3 = this.cachedProperties;
        synchronized (map3) {
            PropertiesHolder propHolder = this.cachedProperties.get(filename);
            if (propHolder != null && (propHolder.getRefreshTimestamp() < 0L || propHolder.getRefreshTimestamp() > System.currentTimeMillis() - this.cacheMillis)) {
                return propHolder;
            }
            return this.refreshProperties(filename, propHolder);
        }
    }

    protected PropertiesHolder refreshProperties(String filename, PropertiesHolder propHolder) {
        long refreshTimestamp = this.cacheMillis < 0L ? -1L : System.currentTimeMillis();
        Resource resource = this.resourceLoader.getResource(String.valueOf(filename) + PROPERTIES_SUFFIX);
        if (!resource.exists()) {
            resource = this.resourceLoader.getResource(String.valueOf(filename) + XML_SUFFIX);
        }
        if (resource.exists()) {
            long fileTimestamp = -1L;
            if (this.cacheMillis >= 0L) {
                try {
                    fileTimestamp = resource.lastModified();
                    if (propHolder != null && propHolder.getFileTimestamp() == fileTimestamp) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Re-caching properties for filename [" + filename + "] - file hasn't been modified");
                        }
                        propHolder.setRefreshTimestamp(refreshTimestamp);
                        return propHolder;
                    }
                }
                catch (IOException ex2) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(resource + " could not be resolved in the file system - assuming that is hasn't changed", ex2);
                    }
                    fileTimestamp = -1L;
                }
            }
            try {
                Properties props = this.loadProperties(resource, filename);
                propHolder = new PropertiesHolder(props, fileTimestamp);
            }
            catch (IOException ex3) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Could not parse properties file [" + resource.getFilename() + "]", ex3);
                }
                propHolder = new PropertiesHolder();
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No properties file found for [" + filename + "] - neither plain properties nor XML");
            }
            propHolder = new PropertiesHolder();
        }
        propHolder.setRefreshTimestamp(refreshTimestamp);
        this.cachedProperties.put(filename, propHolder);
        return propHolder;
    }

    protected Properties loadProperties(Resource resource, String filename) throws IOException {
        InputStream is2 = resource.getInputStream();
        Properties props = new Properties();
        try {
            if (resource.getFilename().endsWith(XML_SUFFIX)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loading properties [" + resource.getFilename() + "]");
                }
                this.propertiesPersister.loadFromXml(props, is2);
            } else {
                String encoding = null;
                if (this.fileEncodings != null) {
                    encoding = this.fileEncodings.getProperty(filename);
                }
                if (encoding == null) {
                    encoding = this.defaultEncoding;
                }
                if (encoding != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Loading properties [" + resource.getFilename() + "] with encoding '" + encoding + "'");
                    }
                    this.propertiesPersister.load(props, new InputStreamReader(is2, encoding));
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Loading properties [" + resource.getFilename() + "]");
                    }
                    this.propertiesPersister.load(props, is2);
                }
            }
            Properties properties2 = props;
            return properties2;
        }
        finally {
            is2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.debug("Clearing entire resource bundle cache");
        Map<Object, PropertiesHolder> map3 = this.cachedProperties;
        synchronized (map3) {
            this.cachedProperties.clear();
        }
        map3 = this.cachedMergedProperties;
        synchronized (map3) {
            this.cachedMergedProperties.clear();
        }
    }

    public void clearCacheIncludingAncestors() {
        this.clearCache();
        if (this.getParentMessageSource() instanceof ReloadableResourceBundleMessageSource) {
            ((ReloadableResourceBundleMessageSource)this.getParentMessageSource()).clearCacheIncludingAncestors();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": basenames=[" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }

    protected class PropertiesHolder {
        private Properties properties;
        private long fileTimestamp = -1L;
        private long refreshTimestamp = -1L;
        private final Map<String, Map<Locale, MessageFormat>> cachedMessageFormats = new HashMap<String, Map<Locale, MessageFormat>>();

        public PropertiesHolder(Properties properties2, long fileTimestamp) {
            this.properties = properties2;
            this.fileTimestamp = fileTimestamp;
        }

        public PropertiesHolder() {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public long getFileTimestamp() {
            return this.fileTimestamp;
        }

        public void setRefreshTimestamp(long refreshTimestamp) {
            this.refreshTimestamp = refreshTimestamp;
        }

        public long getRefreshTimestamp() {
            return this.refreshTimestamp;
        }

        public String getProperty(String code2) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.getProperty(code2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageFormat getMessageFormat(String code2, Locale locale) {
            if (this.properties == null) {
                return null;
            }
            Map<String, Map<Locale, MessageFormat>> map3 = this.cachedMessageFormats;
            synchronized (map3) {
                MessageFormat result2;
                Map<Locale, MessageFormat> localeMap = this.cachedMessageFormats.get(code2);
                if (localeMap != null && (result2 = localeMap.get(locale)) != null) {
                    return result2;
                }
                String msg = this.properties.getProperty(code2);
                if (msg != null) {
                    if (localeMap == null) {
                        localeMap = new HashMap<Locale, MessageFormat>();
                        this.cachedMessageFormats.put(code2, localeMap);
                    }
                    MessageFormat result3 = ReloadableResourceBundleMessageSource.this.createMessageFormat(msg, locale);
                    localeMap.put(locale, result3);
                    return result3;
                }
                return null;
            }
        }
    }
}

