/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.springframework.util.ClassUtils;

public class ConfigurableObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;
    private final boolean acceptProxyClasses;

    public ConfigurableObjectInputStream(InputStream in2, ClassLoader classLoader) throws IOException {
        this(in2, classLoader, true);
    }

    public ConfigurableObjectInputStream(InputStream in2, ClassLoader classLoader, boolean acceptProxyClasses) throws IOException {
        super(in2);
        this.classLoader = classLoader;
        this.acceptProxyClasses = acceptProxyClasses;
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        try {
            if (this.classLoader != null) {
                return ClassUtils.forName(classDesc.getName(), this.classLoader);
            }
            return super.resolveClass(classDesc);
        }
        catch (ClassNotFoundException ex2) {
            return this.resolveFallbackIfPossible(classDesc.getName(), ex2);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (!this.acceptProxyClasses) {
            throw new NotSerializableException("Not allowed to accept serialized proxy classes");
        }
        if (this.classLoader != null) {
            resolvedInterfaces = new Class[interfaces.length];
            i = 0;
            while (i < interfaces.length) {
                try {
                    resolvedInterfaces[i] = ClassUtils.forName(interfaces[i], this.classLoader);
                }
                catch (ClassNotFoundException ex) {
                    resolvedInterfaces[i] = this.resolveFallbackIfPossible(interfaces[i], ex);
                }
                ++i;
            }
            try {
                return Proxy.getProxyClass(this.classLoader, resolvedInterfaces);
            }
            catch (IllegalArgumentException ex) {
                throw new ClassNotFoundException(null, ex);
            }
        }
        try {
            return super.resolveProxyClass(interfaces);
        }
        catch (ClassNotFoundException ex) {
            resolvedInterfaces = new Class[interfaces.length];
            i = 0;
            ** while (i < interfaces.length)
        }
lbl-1000:
        // 1 sources

        {
            resolvedInterfaces[i] = this.resolveFallbackIfPossible(interfaces[i], ex);
            ++i;
            continue;
        }
lbl27:
        // 1 sources

        return Proxy.getProxyClass(this.getFallbackClassLoader(), resolvedInterfaces);
    }

    protected Class resolveFallbackIfPossible(String className, ClassNotFoundException ex2) throws IOException, ClassNotFoundException {
        throw ex2;
    }

    protected ClassLoader getFallbackClassLoader() throws IOException {
        return null;
    }
}

