/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ConstantException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constants {
    private final String className;
    private final Map<String, Object> fieldCache = new HashMap<String, Object>();

    public Constants(Class clazz2) {
        Field[] fields;
        Assert.notNull(clazz2);
        this.className = clazz2.getName();
        Field[] fieldArray = fields = clazz2.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field2 = fieldArray[n2];
            if (ReflectionUtils.isPublicStaticFinal(field2)) {
                String name = field2.getName();
                try {
                    Object value2 = field2.get(null);
                    this.fieldCache.put(name, value2);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
    }

    public final String getClassName() {
        return this.className;
    }

    public final int getSize() {
        return this.fieldCache.size();
    }

    protected final Map<String, Object> getFieldCache() {
        return this.fieldCache;
    }

    public Number asNumber(String code2) throws ConstantException {
        Object obj = this.asObject(code2);
        if (!(obj instanceof Number)) {
            throw new ConstantException(this.className, code2, "not a Number");
        }
        return (Number)obj;
    }

    public String asString(String code2) throws ConstantException {
        return this.asObject(code2).toString();
    }

    public Object asObject(String code2) throws ConstantException {
        Assert.notNull(code2, "Code must not be null");
        String codeToUse = code2.toUpperCase(Locale.ENGLISH);
        Object val = this.fieldCache.get(codeToUse);
        if (val == null) {
            throw new ConstantException(this.className, codeToUse, "not found");
        }
        return val;
    }

    public Set<String> getNames(String namePrefix) {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> names = new HashSet<String>();
        for (String code2 : this.fieldCache.keySet()) {
            if (!code2.startsWith(prefixToUse)) continue;
            names.add(code2);
        }
        return names;
    }

    public Set<String> getNamesForProperty(String propertyName) {
        return this.getNames(this.propertyToConstantNamePrefix(propertyName));
    }

    public Set getNamesForSuffix(String nameSuffix) {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> names = new HashSet<String>();
        for (String code2 : this.fieldCache.keySet()) {
            if (!code2.endsWith(suffixToUse)) continue;
            names.add(code2);
        }
        return names;
    }

    public Set<Object> getValues(String namePrefix) {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<Object> values2 = new HashSet<Object>();
        for (String code2 : this.fieldCache.keySet()) {
            if (!code2.startsWith(prefixToUse)) continue;
            values2.add(this.fieldCache.get(code2));
        }
        return values2;
    }

    public Set<Object> getValuesForProperty(String propertyName) {
        return this.getValues(this.propertyToConstantNamePrefix(propertyName));
    }

    public Set<Object> getValuesForSuffix(String nameSuffix) {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<Object> values2 = new HashSet<Object>();
        for (String code2 : this.fieldCache.keySet()) {
            if (!code2.endsWith(suffixToUse)) continue;
            values2.add(this.fieldCache.get(code2));
        }
        return values2;
    }

    public String toCode(Object value2, String namePrefix) throws ConstantException {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : null;
        for (Map.Entry<String, Object> entry2 : this.fieldCache.entrySet()) {
            if (!entry2.getKey().startsWith(prefixToUse) || !entry2.getValue().equals(value2)) continue;
            return entry2.getKey();
        }
        throw new ConstantException(this.className, prefixToUse, value2);
    }

    public String toCodeForProperty(Object value2, String propertyName) throws ConstantException {
        return this.toCode(value2, this.propertyToConstantNamePrefix(propertyName));
    }

    public String toCodeForSuffix(Object value2, String nameSuffix) throws ConstantException {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : null;
        for (Map.Entry<String, Object> entry2 : this.fieldCache.entrySet()) {
            if (!entry2.getKey().endsWith(suffixToUse) || !entry2.getValue().equals(value2)) continue;
            return entry2.getKey();
        }
        throw new ConstantException(this.className, suffixToUse, value2);
    }

    public String propertyToConstantNamePrefix(String propertyName) {
        StringBuilder parsedPrefix = new StringBuilder();
        int i = 0;
        while (i < propertyName.length()) {
            char c2 = propertyName.charAt(i);
            if (Character.isUpperCase(c2)) {
                parsedPrefix.append("_");
                parsedPrefix.append(c2);
            } else {
                parsedPrefix.append(Character.toUpperCase(c2));
            }
            ++i;
        }
        return parsedPrefix.toString();
    }
}

