/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.core.ControlFlow;
import org.springframework.util.Assert;

public abstract class ControlFlowFactory {
    public static ControlFlow createControlFlow() {
        return new Jdk14ControlFlow();
    }

    static class Jdk14ControlFlow
    implements ControlFlow {
        private StackTraceElement[] stack = new Throwable().getStackTrace();

        public boolean under(Class clazz2) {
            Assert.notNull(clazz2, "Class must not be null");
            String className = clazz2.getName();
            int i = 0;
            while (i < this.stack.length) {
                if (this.stack[i].getClassName().equals(className)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean under(Class clazz2, String methodName) {
            Assert.notNull(clazz2, "Class must not be null");
            Assert.notNull(methodName, "Method name must not be null");
            String className = clazz2.getName();
            int i = 0;
            while (i < this.stack.length) {
                if (this.stack[i].getClassName().equals(className) && this.stack[i].getMethodName().equals(methodName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean underToken(String token2) {
            if (token2 == null) {
                return false;
            }
            StringWriter sw = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            return stackTrace.indexOf(token2) != -1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Jdk14ControlFlow: ");
            int i = 0;
            while (i < this.stack.length) {
                if (i > 0) {
                    sb.append("\n\t@");
                }
                sb.append(this.stack[i]);
                ++i;
            }
            return sb.toString();
        }
    }
}

