/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class Conventions {
    private static final String PLURAL_SUFFIX = "List";
    private static final Set<Class> ignoredInterfaces = new HashSet<Class>();

    static {
        ignoredInterfaces.add(Serializable.class);
        ignoredInterfaces.add(Externalizable.class);
        ignoredInterfaces.add(Cloneable.class);
        ignoredInterfaces.add(Comparable.class);
    }

    public static String getVariableName(Object value2) {
        Class valueClass;
        Assert.notNull(value2, "Value must not be null");
        boolean pluralize = false;
        if (value2.getClass().isArray()) {
            valueClass = value2.getClass().getComponentType();
            pluralize = true;
        } else if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            Object valueToCheck = Conventions.peekAhead(collection);
            valueClass = Conventions.getClassForValue(valueToCheck);
            pluralize = true;
        } else {
            valueClass = Conventions.getClassForValue(value2);
        }
        String name = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String getVariableNameForParameter(MethodParameter parameter) {
        Class<?> valueClass;
        Assert.notNull(parameter, "MethodParameter must not be null");
        boolean pluralize = false;
        if (parameter.getParameterType().isArray()) {
            valueClass = parameter.getParameterType().getComponentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(parameter.getParameterType())) {
            valueClass = GenericCollectionTypeResolver.getCollectionParameterType(parameter);
            if (valueClass == null) {
                throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection parameter type");
            }
            pluralize = true;
        } else {
            valueClass = parameter.getParameterType();
        }
        String name = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String getVariableNameForReturnType(Method method) {
        return Conventions.getVariableNameForReturnType(method, method.getReturnType(), null);
    }

    public static String getVariableNameForReturnType(Method method, Object value2) {
        return Conventions.getVariableNameForReturnType(method, method.getReturnType(), value2);
    }

    public static String getVariableNameForReturnType(Method method, Class resolvedType, Object value2) {
        Class valueClass;
        Assert.notNull(method, "Method must not be null");
        if (Object.class.equals((Object)resolvedType)) {
            if (value2 == null) {
                throw new IllegalArgumentException("Cannot generate variable name for an Object return type with null value");
            }
            return Conventions.getVariableName(value2);
        }
        boolean pluralize = false;
        if (resolvedType.isArray()) {
            valueClass = resolvedType.getComponentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(resolvedType)) {
            valueClass = GenericCollectionTypeResolver.getCollectionReturnType(method);
            if (valueClass == null) {
                if (!(value2 instanceof Collection)) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and a non-Collection value");
                }
                Collection collection = (Collection)value2;
                if (collection.isEmpty()) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and an empty Collection value");
                }
                Object valueToCheck = Conventions.peekAhead(collection);
                valueClass = Conventions.getClassForValue(valueToCheck);
            }
            pluralize = true;
        } else {
            valueClass = resolvedType;
        }
        String name = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String attributeNameToPropertyName(String attributeName) {
        Assert.notNull(attributeName, "'attributeName' must not be null");
        if (!attributeName.contains("-")) {
            return attributeName;
        }
        char[] chars = attributeName.toCharArray();
        char[] result2 = new char[chars.length - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (c2 == '-') {
                upperCaseNext = true;
            } else if (upperCaseNext) {
                result2[currPos++] = Character.toUpperCase(c2);
                upperCaseNext = false;
            } else {
                result2[currPos++] = c2;
            }
            ++n2;
        }
        return new String(result2, 0, currPos);
    }

    public static String getQualifiedAttributeName(Class enclosingClass, String attributeName) {
        Assert.notNull(enclosingClass, "'enclosingClass' must not be null");
        Assert.notNull(attributeName, "'attributeName' must not be null");
        return String.valueOf(enclosingClass.getName()) + "." + attributeName;
    }

    private static Class getClassForValue(Object value2) {
        Class<?> valueClass = value2.getClass();
        if (Proxy.isProxyClass(valueClass)) {
            Class<?>[] ifcs;
            Class<?>[] classArray = ifcs = valueClass.getInterfaces();
            int n = ifcs.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> ifc = classArray[n2];
                if (!ignoredInterfaces.contains(ifc)) {
                    return ifc;
                }
                ++n2;
            }
        } else if (valueClass.getName().lastIndexOf(36) != -1 && valueClass.getDeclaringClass() == null) {
            valueClass = valueClass.getSuperclass();
        }
        return valueClass;
    }

    private static String pluralize(String name) {
        return String.valueOf(name) + PLURAL_SUFFIX;
    }

    private static Object peekAhead(Collection collection) {
        Iterator it = collection.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
        }
        Object value2 = it.next();
        if (value2 == null) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - only null element found");
        }
        return value2;
    }
}

