/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    public AnnotationAttributes() {
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity);
    }

    public AnnotationAttributes(Map<String, Object> map3) {
        super(map3);
    }

    public static AnnotationAttributes fromMap(Map<String, Object> map3) {
        if (map3 == null) {
            return null;
        }
        if (map3 instanceof AnnotationAttributes) {
            return (AnnotationAttributes)map3;
        }
        return new AnnotationAttributes(map3);
    }

    public String getString(String attributeName) {
        return this.doGet(attributeName, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.doGet(attributeName, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.doGet(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.doGet(attributeName, Integer.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.doGet(attributeName, Enum.class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.doGet(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.doGet(attributeName, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String attributeName) {
        return this.doGet(attributeName, AnnotationAttributes.class);
    }

    public AnnotationAttributes[] getAnnotationArray(String attributeName) {
        return this.doGet(attributeName, AnnotationAttributes[].class);
    }

    private <T> T doGet(String attributeName, Class<T> expectedType) {
        Assert.hasText(attributeName, "attributeName must not be null or empty");
        Object value2 = this.get(attributeName);
        Assert.notNull(value2, String.format("Attribute '%s' not found", attributeName));
        Assert.isAssignable(expectedType, value2.getClass(), String.format("Attribute '%s' is of type [%s], but [%s] was expected. Cause: ", attributeName, value2.getClass().getSimpleName(), expectedType.getSimpleName()));
        return (T)value2;
    }
}

