/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDescriptor {
    private final Class<?> type;

    protected AbstractDescriptor(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public TypeDescriptor getElementTypeDescriptor() {
        if (this.isCollection()) {
            Class<?> elementType2 = this.resolveCollectionElementType();
            return elementType2 != null ? new TypeDescriptor(this.nested(elementType2, 0)) : null;
        }
        if (this.isArray()) {
            Class<?> elementType3 = this.getType().getComponentType();
            return new TypeDescriptor(this.nested(elementType3, 0));
        }
        return null;
    }

    public TypeDescriptor getMapKeyTypeDescriptor() {
        if (this.isMap()) {
            Class<?> keyType = this.resolveMapKeyType();
            return keyType != null ? new TypeDescriptor(this.nested(keyType, 0)) : null;
        }
        return null;
    }

    public TypeDescriptor getMapValueTypeDescriptor() {
        if (this.isMap()) {
            Class<?> valueType = this.resolveMapValueType();
            return valueType != null ? new TypeDescriptor(this.nested(valueType, 1)) : null;
        }
        return null;
    }

    public AbstractDescriptor nested() {
        if (this.isCollection()) {
            Class<?> elementType2 = this.resolveCollectionElementType();
            return elementType2 != null ? this.nested(elementType2, 0) : null;
        }
        if (this.isArray()) {
            return this.nested(this.getType().getComponentType(), 0);
        }
        if (this.isMap()) {
            Class<?> mapValueType = this.resolveMapValueType();
            return mapValueType != null ? this.nested(mapValueType, 1) : null;
        }
        if (Object.class.equals(this.getType())) {
            return this;
        }
        throw new IllegalStateException("Not a collection, array, or map: cannot resolve nested value types");
    }

    public abstract Annotation[] getAnnotations();

    protected abstract Class<?> resolveCollectionElementType();

    protected abstract Class<?> resolveMapKeyType();

    protected abstract Class<?> resolveMapValueType();

    protected abstract AbstractDescriptor nested(Class<?> var1, int var2);

    private boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    private boolean isArray() {
        return this.getType().isArray();
    }

    private boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }
}

