/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Property {
    private final Class<?> objectType;
    private final Method readMethod;
    private final Method writeMethod;
    private final String name;
    private final MethodParameter methodParameter;
    private final Annotation[] annotations;

    public Property(Class<?> objectType, Method readMethod, Method writeMethod) {
        this.objectType = objectType;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.methodParameter = this.resolveMethodParameter();
        this.name = this.resolveName();
        this.annotations = this.resolveAnnotations();
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.methodParameter.getParameterType();
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    Annotation[] getAnnotations() {
        return this.annotations;
    }

    private String resolveName() {
        if (this.readMethod != null) {
            int index2 = this.readMethod.getName().indexOf("get");
            if (index2 != -1) {
                index2 += 3;
            } else {
                index2 = this.readMethod.getName().indexOf("is");
                if (index2 == -1) {
                    throw new IllegalArgumentException("Not a getter method");
                }
                index2 += 2;
            }
            return StringUtils.uncapitalize(this.readMethod.getName().substring(index2));
        }
        int index3 = this.writeMethod.getName().indexOf("set") + 3;
        if (index3 == -1) {
            throw new IllegalArgumentException("Not a setter method");
        }
        return StringUtils.uncapitalize(this.writeMethod.getName().substring(index3));
    }

    private MethodParameter resolveMethodParameter() {
        MethodParameter read2 = this.resolveReadMethodParameter();
        MethodParameter write2 = this.resolveWriteMethodParameter();
        if (write2 == null) {
            if (read2 == null) {
                throw new IllegalStateException("Property is neither readable nor writeable");
            }
            return read2;
        }
        if (read2 != null) {
            Class<?> readType2 = read2.getParameterType();
            Class<?> writeType = write2.getParameterType();
            if (!writeType.equals(readType2) && writeType.isAssignableFrom(readType2)) {
                return read2;
            }
        }
        return write2;
    }

    private MethodParameter resolveReadMethodParameter() {
        if (this.getReadMethod() == null) {
            return null;
        }
        return this.resolveParameterType(new MethodParameter(this.getReadMethod(), -1));
    }

    private MethodParameter resolveWriteMethodParameter() {
        if (this.getWriteMethod() == null) {
            return null;
        }
        return this.resolveParameterType(new MethodParameter(this.getWriteMethod(), 0));
    }

    private MethodParameter resolveParameterType(MethodParameter parameter) {
        GenericTypeResolver.resolveParameterType(parameter, this.getObjectType());
        return parameter;
    }

    private Annotation[] resolveAnnotations() {
        Field field2;
        Method writeMethod;
        int n;
        LinkedHashMap<Class<? extends Annotation>, Annotation> annMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        Method readMethod = this.getReadMethod();
        if (readMethod != null) {
            Annotation[] annotationArray = readMethod.getAnnotations();
            n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                annMap.put(ann.annotationType(), ann);
                ++n2;
            }
        }
        if ((writeMethod = this.getWriteMethod()) != null) {
            Annotation[] annotationArray = writeMethod.getAnnotations();
            int n3 = annotationArray.length;
            n = 0;
            while (n < n3) {
                Annotation ann = annotationArray[n];
                annMap.put(ann.annotationType(), ann);
                ++n;
            }
        }
        if ((field2 = this.getField()) != null) {
            Annotation[] annotationArray = field2.getAnnotations();
            int n4 = annotationArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation ann = annotationArray[n5];
                annMap.put(ann.annotationType(), ann);
                ++n5;
            }
        }
        return annMap.values().toArray(new Annotation[annMap.size()]);
    }

    private Field getField() {
        String name = this.getName();
        if (!StringUtils.hasLength(name)) {
            return null;
        }
        Class<?> declaringClass = this.declaringClass();
        Field field2 = ReflectionUtils.findField(declaringClass, name);
        if (field2 == null && (field2 = ReflectionUtils.findField(declaringClass, String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1))) == null) {
            field2 = ReflectionUtils.findField(declaringClass, String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1));
        }
        return field2;
    }

    private Class<?> declaringClass() {
        if (this.getReadMethod() != null) {
            return this.getReadMethod().getDeclaringClass();
        }
        return this.getWriteMethod().getDeclaringClass();
    }
}

