/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

abstract class ConversionUtils {
    ConversionUtils() {
    }

    public static Object invokeConverter(GenericConverter converter, Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return converter.convert(source, sourceType, targetType);
        }
        catch (ConversionFailedException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new ConversionFailedException(sourceType, targetType, source, ex3);
        }
    }

    public static boolean canConvertElements(TypeDescriptor sourceElementType, TypeDescriptor targetElementType, ConversionService conversionService) {
        if (targetElementType == null) {
            return true;
        }
        if (sourceElementType == null) {
            return true;
        }
        if (conversionService.canConvert(sourceElementType, targetElementType)) {
            return true;
        }
        return sourceElementType.getType().isAssignableFrom(targetElementType.getType());
    }
}

