/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConversionService
implements ConfigurableConversionService {
    private static final GenericConverter NO_OP_CONVERTER = new GenericConverter(){

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return null;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source;
        }

        public String toString() {
            return "NO_OP";
        }
    };
    private static final GenericConverter NO_MATCH = new GenericConverter(){

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "NO_MATCH";
        }
    };
    private final Map<Class<?>, Map<Class<?>, MatchableConverters>> converters = new HashMap(36);
    private final Map<ConverterCacheKey, GenericConverter> converterCache = new ConcurrentHashMap<ConverterCacheKey, GenericConverter>();

    @Override
    public void addConverter(Converter<?, ?> converter) {
        GenericConverter.ConvertiblePair typeInfo = this.getRequiredTypeInfo(converter, Converter.class);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetType <T> which your Converter<S, T> converts between; declare these generic types.");
        }
        this.addConverter(new ConverterAdapter(typeInfo, converter));
    }

    @Override
    public void addConverter(Class<?> sourceType, Class<?> targetType, Converter<?, ?> converter) {
        GenericConverter.ConvertiblePair typeInfo = new GenericConverter.ConvertiblePair(sourceType, targetType);
        this.addConverter(new ConverterAdapter(typeInfo, converter));
    }

    @Override
    public void addConverter(GenericConverter converter) {
        Set<GenericConverter.ConvertiblePair> convertibleTypes = converter.getConvertibleTypes();
        for (GenericConverter.ConvertiblePair convertibleType : convertibleTypes) {
            this.getMatchableConverters(convertibleType.getSourceType(), convertibleType.getTargetType()).add(converter);
        }
        this.invalidateCache();
    }

    @Override
    public void addConverterFactory(ConverterFactory<?, ?> converterFactory) {
        GenericConverter.ConvertiblePair typeInfo = this.getRequiredTypeInfo(converterFactory, ConverterFactory.class);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetRangeType R which your ConverterFactory<S, R> converts between; declare these generic types.");
        }
        this.addConverter(new ConverterFactoryAdapter(typeInfo, converterFactory));
    }

    @Override
    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.getSourceConverterMap(sourceType).remove(targetType);
        this.invalidateCache();
    }

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("The targetType to convert to cannot be null");
        }
        return this.canConvert(sourceType != null ? TypeDescriptor.valueOf(sourceType) : null, TypeDescriptor.valueOf(targetType));
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("The targetType to convert to cannot be null");
        }
        if (sourceType == null) {
            return true;
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        return converter != null;
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("The targetType to convert to cannot be null");
        }
        return (T)this.convert(source, TypeDescriptor.forObject(source), TypeDescriptor.valueOf(targetType));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("The targetType to convert to cannot be null");
        }
        if (sourceType == null) {
            Assert.isTrue(source == null, "The source must be [null] if sourceType == [null]");
            return this.handleResult(sourceType, targetType, this.convertNullSource(sourceType, targetType));
        }
        if (source != null && !sourceType.getObjectType().isInstance(source)) {
            throw new IllegalArgumentException("The source to convert from must be an instance of " + sourceType + "; instead it was a " + source.getClass().getName());
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        if (converter != null) {
            Object result2 = ConversionUtils.invokeConverter(converter, source, sourceType, targetType);
            return this.handleResult(sourceType, targetType, result2);
        }
        return this.handleConverterNotFound(source, sourceType, targetType);
    }

    public Object convert(Object source, TypeDescriptor targetType) {
        return this.convert(source, TypeDescriptor.forObject(source), targetType);
    }

    public String toString() {
        ArrayList<String> converterStrings = new ArrayList<String>();
        for (Map<Class<?>, MatchableConverters> targetConverters : this.converters.values()) {
            for (MatchableConverters matchable : targetConverters.values()) {
                converterStrings.add(matchable.toString());
            }
        }
        Collections.sort(converterStrings);
        StringBuilder builder = new StringBuilder();
        builder.append("ConversionService converters = ").append("\n");
        for (String converterString : converterStrings) {
            builder.append("\t");
            builder.append(converterString);
            builder.append("\n");
        }
        return builder.toString();
    }

    protected Object convertNullSource(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return null;
    }

    protected GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        ConverterCacheKey key = new ConverterCacheKey(sourceType, targetType);
        GenericConverter converter = this.converterCache.get(key);
        if (converter != null) {
            return converter != NO_MATCH ? converter : null;
        }
        converter = this.findConverterForClassPair(sourceType, targetType);
        if (converter == null) {
            converter = this.getDefaultConverter(sourceType, targetType);
        }
        if (converter != null) {
            this.converterCache.put(key, converter);
            return converter;
        }
        this.converterCache.put(key, NO_MATCH);
        return null;
    }

    protected GenericConverter getDefaultConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return sourceType.isAssignableTo(targetType) ? NO_OP_CONVERTER : null;
    }

    private GenericConverter.ConvertiblePair getRequiredTypeInfo(Object converter, Class<?> genericIfc) {
        Class[] args2 = GenericTypeResolver.resolveTypeArguments(converter.getClass(), genericIfc);
        return args2 != null ? new GenericConverter.ConvertiblePair(args2[0], args2[1]) : null;
    }

    private MatchableConverters getMatchableConverters(Class<?> sourceType, Class<?> targetType) {
        Map<Class<?>, MatchableConverters> sourceMap = this.getSourceConverterMap(sourceType);
        MatchableConverters matchable = sourceMap.get(targetType);
        if (matchable == null) {
            matchable = new MatchableConverters();
            sourceMap.put(targetType, matchable);
        }
        return matchable;
    }

    private void invalidateCache() {
        this.converterCache.clear();
    }

    private Map<Class<?>, MatchableConverters> getSourceConverterMap(Class<?> sourceType) {
        Map<Class<?>, MatchableConverters> sourceMap = this.converters.get(sourceType);
        if (sourceMap == null) {
            sourceMap = new HashMap();
            this.converters.put(sourceType, sourceMap);
        }
        return sourceMap;
    }

    private GenericConverter findConverterForClassPair(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class<?> sourceObjectType = sourceType.getObjectType();
        if (sourceObjectType.isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(sourceObjectType);
            while (!classQueue.isEmpty()) {
                Class<?>[] interfaces2;
                Class currentClass = (Class)classQueue.removeLast();
                Map<Class<?>, MatchableConverters> map3 = this.getTargetConvertersForSource(currentClass);
                GenericConverter converter = this.getMatchingConverterForTarget(sourceType, targetType, map3);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] classArray = interfaces2 = currentClass.getInterfaces();
                int n = interfaces2.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    classQueue.addFirst(ifc);
                    ++n2;
                }
            }
            Map<Class<?>, MatchableConverters> objectConverters = this.getTargetConvertersForSource(Object.class);
            return this.getMatchingConverterForTarget(sourceType, targetType, objectConverters);
        }
        if (sourceObjectType.isArray()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(sourceObjectType);
            while (!classQueue.isEmpty()) {
                Class currentClass = (Class)classQueue.removeLast();
                Map<Class<?>, MatchableConverters> map4 = this.getTargetConvertersForSource(currentClass);
                GenericConverter converter = this.getMatchingConverterForTarget(sourceType, targetType, map4);
                if (converter != null) {
                    return converter;
                }
                Class<?> componentType = ClassUtils.resolvePrimitiveIfNecessary(currentClass.getComponentType());
                if (componentType.getSuperclass() != null) {
                    classQueue.addFirst(Array.newInstance(componentType.getSuperclass(), 0).getClass());
                    continue;
                }
                if (!componentType.isInterface()) continue;
                classQueue.addFirst(Object[].class);
            }
            return null;
        }
        LinkedHashSet interfaces3 = new LinkedHashSet();
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(sourceObjectType);
        while (!classQueue.isEmpty()) {
            Class clazz2 = (Class)classQueue.removeLast();
            Map<Class<?>, MatchableConverters> converters = this.getTargetConvertersForSource(clazz2);
            GenericConverter converter = this.getMatchingConverterForTarget(sourceType, targetType, converters);
            if (converter != null) {
                return converter;
            }
            Class superClass = clazz2.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                classQueue.addFirst(superClass);
            }
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> interfaceType = classArray[n3];
                this.addInterfaceHierarchy(interfaceType, interfaces3);
                ++n3;
            }
        }
        for (Class clazz3 : interfaces3) {
            Map<Class<?>, MatchableConverters> converters = this.getTargetConvertersForSource(clazz3);
            GenericConverter converter = this.getMatchingConverterForTarget(sourceType, targetType, converters);
            if (converter == null) continue;
            return converter;
        }
        Map<Class<?>, MatchableConverters> map5 = this.getTargetConvertersForSource(Object.class);
        return this.getMatchingConverterForTarget(sourceType, targetType, map5);
    }

    private Map<Class<?>, MatchableConverters> getTargetConvertersForSource(Class<?> sourceType) {
        Map<Class<Object>, MatchableConverters> converters = this.converters.get(sourceType);
        if (converters == null) {
            converters = Collections.emptyMap();
        }
        return converters;
    }

    private GenericConverter getMatchingConverterForTarget(TypeDescriptor sourceType, TypeDescriptor targetType, Map<Class<?>, MatchableConverters> converters) {
        Class<?> targetObjectType = targetType.getObjectType();
        if (targetObjectType.isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(targetObjectType);
            while (!classQueue.isEmpty()) {
                Class<?>[] interfaces2;
                Class currentClass = (Class)classQueue.removeLast();
                MatchableConverters matchableConverters = converters.get(currentClass);
                GenericConverter converter = this.matchConverter(matchableConverters, sourceType, targetType);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] classArray = interfaces2 = currentClass.getInterfaces();
                int n = interfaces2.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    classQueue.addFirst(ifc);
                    ++n2;
                }
            }
            return this.matchConverter(converters.get(Object.class), sourceType, targetType);
        }
        if (targetObjectType.isArray()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(targetObjectType);
            while (!classQueue.isEmpty()) {
                Class currentClass = (Class)classQueue.removeLast();
                MatchableConverters matchableConverters = converters.get(currentClass);
                GenericConverter converter = this.matchConverter(matchableConverters, sourceType, targetType);
                if (converter != null) {
                    return converter;
                }
                Class<?> componentType = ClassUtils.resolvePrimitiveIfNecessary(currentClass.getComponentType());
                if (componentType.getSuperclass() != null) {
                    classQueue.addFirst(Array.newInstance(componentType.getSuperclass(), 0).getClass());
                    continue;
                }
                if (!componentType.isInterface()) continue;
                classQueue.addFirst(Object[].class);
            }
            return null;
        }
        LinkedHashSet interfaces3 = new LinkedHashSet();
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(targetObjectType);
        while (!classQueue.isEmpty()) {
            Class clazz2 = (Class)classQueue.removeLast();
            MatchableConverters matchable = converters.get(clazz2);
            GenericConverter converter = this.matchConverter(matchable, sourceType, targetType);
            if (converter != null) {
                return converter;
            }
            Class superClass = clazz2.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                classQueue.addFirst(superClass);
            }
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> interfaceType = classArray[n3];
                this.addInterfaceHierarchy(interfaceType, interfaces3);
                ++n3;
            }
        }
        for (Class clazz3 : interfaces3) {
            MatchableConverters matchable = converters.get(clazz3);
            GenericConverter converter = this.matchConverter(matchable, sourceType, targetType);
            if (converter == null) continue;
            return converter;
        }
        return this.matchConverter(converters.get(Object.class), sourceType, targetType);
    }

    private void addInterfaceHierarchy(Class<?> interfaceType, Set<Class<?>> interfaces2) {
        interfaces2.add(interfaceType);
        Class<?>[] classArray = interfaceType.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inheritedInterface = classArray[n2];
            this.addInterfaceHierarchy(inheritedInterface, interfaces2);
            ++n2;
        }
    }

    private GenericConverter matchConverter(MatchableConverters matchable, TypeDescriptor sourceFieldType, TypeDescriptor targetFieldType) {
        if (matchable == null) {
            return null;
        }
        return matchable.matchConverter(sourceFieldType, targetFieldType);
    }

    private Object handleConverterNotFound(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            this.assertNotPrimitiveTargetType(sourceType, targetType);
            return source;
        }
        if (sourceType.isAssignableTo(targetType) && targetType.getObjectType().isInstance(source)) {
            return source;
        }
        throw new ConverterNotFoundException(sourceType, targetType);
    }

    private Object handleResult(TypeDescriptor sourceType, TypeDescriptor targetType, Object result2) {
        if (result2 == null) {
            this.assertNotPrimitiveTargetType(sourceType, targetType);
        }
        return result2;
    }

    private void assertNotPrimitiveTargetType(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.isPrimitive()) {
            throw new ConversionFailedException(sourceType, targetType, null, new IllegalArgumentException("A null value cannot be assigned to a primitive type"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConverterAdapter
    implements GenericConverter {
        private final GenericConverter.ConvertiblePair typeInfo;
        private final Converter<Object, Object> converter;

        public ConverterAdapter(GenericConverter.ConvertiblePair typeInfo, Converter<?, ?> converter) {
            this.converter = converter;
            this.typeInfo = typeInfo;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        public boolean matchesTargetType(TypeDescriptor targetType) {
            return this.typeInfo.getTargetType().equals(targetType.getObjectType());
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converter.convert(source);
        }

        public String toString() {
            return String.valueOf(this.typeInfo.getSourceType().getName()) + " -> " + this.typeInfo.getTargetType().getName() + " : " + this.converter.toString();
        }
    }

    private static final class ConverterCacheKey {
        private final TypeDescriptor sourceType;
        private final TypeDescriptor targetType;

        public ConverterCacheKey(TypeDescriptor sourceType, TypeDescriptor targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConverterCacheKey)) {
                return false;
            }
            ConverterCacheKey otherKey = (ConverterCacheKey)other;
            return this.sourceType.equals(otherKey.sourceType) && this.targetType.equals(otherKey.targetType);
        }

        public int hashCode() {
            return this.sourceType.hashCode() * 29 + this.targetType.hashCode();
        }

        public String toString() {
            return "ConverterCacheKey [sourceType = " + this.sourceType + ", targetType = " + this.targetType + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConverterFactoryAdapter
    implements GenericConverter {
        private final GenericConverter.ConvertiblePair typeInfo;
        private final ConverterFactory<Object, Object> converterFactory;

        public ConverterFactoryAdapter(GenericConverter.ConvertiblePair typeInfo, ConverterFactory<?, ?> converterFactory) {
            this.converterFactory = converterFactory;
            this.typeInfo = typeInfo;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converterFactory.getConverter(targetType.getObjectType()).convert(source);
        }

        public String toString() {
            return String.valueOf(this.typeInfo.getSourceType().getName()) + " -> " + this.typeInfo.getTargetType().getName() + " : " + this.converterFactory.toString();
        }
    }

    private static class MatchableConverters {
        private LinkedList<ConditionalGenericConverter> conditionalConverters;
        private GenericConverter defaultConverter;

        private MatchableConverters() {
        }

        public void add(GenericConverter converter) {
            if (converter instanceof ConditionalGenericConverter) {
                if (this.conditionalConverters == null) {
                    this.conditionalConverters = new LinkedList();
                }
                this.conditionalConverters.addFirst((ConditionalGenericConverter)converter);
            } else {
                this.defaultConverter = converter;
            }
        }

        public GenericConverter matchConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
            ConverterAdapter adapter;
            if (this.conditionalConverters != null) {
                for (ConditionalGenericConverter conditional : this.conditionalConverters) {
                    if (!conditional.matches(sourceType, targetType)) continue;
                    return conditional;
                }
            }
            if (this.defaultConverter instanceof ConverterAdapter && !(adapter = (ConverterAdapter)this.defaultConverter).matchesTargetType(targetType)) {
                return null;
            }
            return this.defaultConverter;
        }

        public String toString() {
            if (this.conditionalConverters != null) {
                StringBuilder builder = new StringBuilder();
                Iterator it = this.conditionalConverters.iterator();
                while (it.hasNext()) {
                    builder.append(it.next());
                    if (!it.hasNext()) continue;
                    builder.append(", ");
                }
                if (this.defaultConverter != null) {
                    builder.append(", ").append(this.defaultConverter);
                }
                return builder.toString();
            }
            return this.defaultConverter.toString();
        }
    }
}

