/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.HashSet;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StringToBooleanConverter
implements Converter<String, Boolean> {
    private static final Set<String> trueValues = new HashSet<String>(4);
    private static final Set<String> falseValues = new HashSet<String>(4);

    static {
        trueValues.add("true");
        trueValues.add("on");
        trueValues.add("yes");
        trueValues.add("1");
        falseValues.add("false");
        falseValues.add("off");
        falseValues.add("no");
        falseValues.add("0");
    }

    StringToBooleanConverter() {
    }

    @Override
    public Boolean convert(String source) {
        String value2 = source.trim();
        if ("".equals(value2)) {
            return null;
        }
        if (trueValues.contains(value2 = value2.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(value2)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + source + "'");
    }
}

