/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StringToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public StringToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.getElementTypeDescriptor() != null) {
            return this.conversionService.canConvert(sourceType, targetType.getElementTypeDescriptor());
        }
        return true;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String string2 = (String)source;
        String[] fields = StringUtils.commaDelimitedListToStringArray(string2);
        Collection target2 = CollectionFactory.createCollection(targetType.getType(), fields.length);
        if (targetType.getElementTypeDescriptor() == null) {
            String[] stringArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field2 = stringArray[n2];
                target2.add(field2.trim());
                ++n2;
            }
        } else {
            String[] stringArray = fields;
            int n = fields.length;
            int n3 = 0;
            while (n3 < n) {
                String field3 = stringArray[n3];
                Object targetElement = this.conversionService.convert(field3.trim(), sourceType, targetType.getElementTypeDescriptor());
                target2.add(targetElement);
                ++n3;
            }
        }
        return target2;
    }
}

