/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceEditor
extends PropertyEditorSupport {
    private final ResourceLoader resourceLoader;
    private final PropertyResolver propertyResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceEditor() {
        this((ResourceLoader)new DefaultResourceLoader(), new StandardEnvironment());
    }

    @Deprecated
    public ResourceEditor(ResourceLoader resourceLoader) {
        this(resourceLoader, new StandardEnvironment(), true);
    }

    public ResourceEditor(ResourceLoader resourceLoader, PropertyResolver propertyResolver) {
        this(resourceLoader, propertyResolver, true);
    }

    @Deprecated
    public ResourceEditor(ResourceLoader resourceLoader, boolean ignoreUnresolvablePlaceholders) {
        this(resourceLoader, new StandardEnvironment(), ignoreUnresolvablePlaceholders);
    }

    public ResourceEditor(ResourceLoader resourceLoader, PropertyResolver propertyResolver, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        Assert.notNull(propertyResolver, "PropertyResolver must not be null");
        this.resourceLoader = resourceLoader;
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public void setAsText(String text2) {
        if (StringUtils.hasText(text2)) {
            String locationToUse = this.resolvePath(text2).trim();
            this.setValue(this.resourceLoader.getResource(locationToUse));
        } else {
            this.setValue(null);
        }
    }

    protected String resolvePath(String path2) {
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(path2) : this.propertyResolver.resolveRequiredPlaceholders(path2);
    }

    public String getAsText() {
        Resource value2 = (Resource)this.getValue();
        try {
            return value2 != null ? value2.getURL().toExternalForm() : "";
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

