/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;

public abstract class PropertiesLoaderSupport {
    public static final String XML_FILE_EXTENSION = ".xml";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Properties[] localProperties;
    protected boolean localOverride = false;
    private Resource[] locations;
    private boolean ignoreResourceNotFound = false;
    private String fileEncoding;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();

    public void setProperties(Properties properties2) {
        this.localProperties = new Properties[]{properties2};
    }

    public void setPropertiesArray(Properties[] propertiesArray) {
        this.localProperties = propertiesArray;
    }

    public void setLocation(Resource location2) {
        this.locations = new Resource[]{location2};
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setLocalOverride(boolean localOverride) {
        this.localOverride = localOverride;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    protected Properties mergeProperties() throws IOException {
        Properties result2 = new Properties();
        if (this.localOverride) {
            this.loadProperties(result2);
        }
        if (this.localProperties != null) {
            Properties[] propertiesArray = this.localProperties;
            int n = this.localProperties.length;
            int n2 = 0;
            while (n2 < n) {
                Properties localProp = propertiesArray[n2];
                CollectionUtils.mergePropertiesIntoMap(localProp, result2);
                ++n2;
            }
        }
        if (!this.localOverride) {
            this.loadProperties(result2);
        }
        return result2;
    }

    protected void loadProperties(Properties props) throws IOException {
        if (this.locations != null) {
            Resource[] resourceArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                block18: {
                    Resource location2 = resourceArray[n2];
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Loading properties file from " + location2);
                    }
                    InputStream is2 = null;
                    try {
                        try {
                            is2 = location2.getInputStream();
                            String filename = location2.getFilename();
                            if (filename != null && filename.endsWith(XML_FILE_EXTENSION)) {
                                this.propertiesPersister.loadFromXml(props, is2);
                            } else if (this.fileEncoding != null) {
                                this.propertiesPersister.load(props, new InputStreamReader(is2, this.fileEncoding));
                            } else {
                                this.propertiesPersister.load(props, is2);
                            }
                        }
                        catch (IOException ex2) {
                            if (this.ignoreResourceNotFound) {
                                if (this.logger.isWarnEnabled()) {
                                    this.logger.warn("Could not load properties from " + location2 + ": " + ex2.getMessage());
                                }
                            } else {
                                throw ex2;
                            }
                            if (is2 != null) {
                                is2.close();
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (is2 != null) {
                            is2.close();
                        }
                        throw throwable2;
                    }
                    if (is2 != null) {
                        is2.close();
                    }
                }
                ++n2;
            }
        }
    }
}

