/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;

public abstract class PropertiesLoaderUtils {
    public static Properties loadProperties(Resource resource) throws IOException {
        Properties props = new Properties();
        PropertiesLoaderUtils.fillProperties(props, resource);
        return props;
    }

    public static void fillProperties(Properties props, Resource resource) throws IOException {
        InputStream is2 = resource.getInputStream();
        try {
            props.load(is2);
        }
        finally {
            is2.close();
        }
    }

    public static Properties loadAllProperties(String resourceName) throws IOException {
        return PropertiesLoaderUtils.loadAllProperties(resourceName, null);
    }

    public static Properties loadAllProperties(String resourceName, ClassLoader classLoader) throws IOException {
        Assert.notNull(resourceName, "Resource name must not be null");
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = ClassUtils.getDefaultClassLoader();
        }
        Properties properties2 = new Properties();
        Enumeration<URL> urls2 = clToUse.getResources(resourceName);
        while (urls2.hasMoreElements()) {
            URL url = urls2.nextElement();
            InputStream is2 = null;
            try {
                URLConnection con = url.openConnection();
                ResourceUtils.useCachesIfNecessary(con);
                is2 = con.getInputStream();
                properties2.load(is2);
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        return properties2;
    }
}

