/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog(ResourceArrayPropertyEditor.class);
    private final PropertyResolver propertyResolver;
    private final ResourcePatternResolver resourcePatternResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceArrayPropertyEditor() {
        this(new PathMatchingResourcePatternResolver(), new StandardEnvironment(), true);
    }

    @Deprecated
    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver) {
        this(resourcePatternResolver, new StandardEnvironment(), true);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, PropertyResolver propertyResolver) {
        this(resourcePatternResolver, propertyResolver, true);
    }

    @Deprecated
    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, boolean ignoreUnresolvablePlaceholders) {
        this(resourcePatternResolver, new StandardEnvironment(), ignoreUnresolvablePlaceholders);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, PropertyResolver propertyResolver, boolean ignoreUnresolvablePlaceholders) {
        this.resourcePatternResolver = resourcePatternResolver;
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public void setAsText(String text2) {
        String pattern = this.resolvePath(text2).trim();
        try {
            this.setValue(this.resourcePatternResolver.getResources(pattern));
        }
        catch (IOException ex2) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex2.getMessage());
        }
    }

    public void setValue(Object value2) throws IllegalArgumentException {
        if (value2 instanceof Collection || value2 instanceof Object[] && !(value2 instanceof Resource[])) {
            Collection input2 = value2 instanceof Collection ? (Collection)value2 : (Collection)Arrays.asList((Object[])value2);
            ArrayList<Resource> merged = new ArrayList<Resource>();
            for (Object element2 : input2) {
                if (element2 instanceof String) {
                    String pattern = this.resolvePath((String)element2).trim();
                    try {
                        Resource[] resources;
                        Resource[] resourceArray = resources = this.resourcePatternResolver.getResources(pattern);
                        int n = resources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Resource resource = resourceArray[n2];
                            if (!merged.contains(resource)) {
                                merged.add(resource);
                            }
                            ++n2;
                        }
                    }
                    catch (IOException ex2) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Could not retrieve resources for pattern '" + pattern + "'", ex2);
                    }
                    continue;
                }
                if (element2 instanceof Resource) {
                    Resource resource = (Resource)element2;
                    if (merged.contains(resource)) continue;
                    merged.add(resource);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + element2 + "] to [" + Resource.class.getName() + "]: only location String and Resource object supported");
            }
            super.setValue(merged.toArray(new Resource[merged.size()]));
        } else {
            super.setValue(value2);
        }
    }

    protected String resolvePath(String path2) {
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(path2) : this.propertyResolver.resolveRequiredPlaceholders(path2);
    }
}

