/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ResourcePropertySource
extends PropertiesPropertySource {
    public ResourcePropertySource(String name, Resource resource) throws IOException {
        super(name, ResourcePropertySource.loadPropertiesForResource(resource));
    }

    public ResourcePropertySource(Resource resource) throws IOException {
        this(ResourcePropertySource.getNameForResource(resource), resource);
    }

    public ResourcePropertySource(String name, String location2, ClassLoader classLoader) throws IOException {
        this(name, ResourcePropertySource.getResourceForLocation(location2, classLoader));
    }

    public ResourcePropertySource(String name, String location2) throws IOException {
        this(name, location2, ClassUtils.getDefaultClassLoader());
    }

    public ResourcePropertySource(String location2, ClassLoader classLoader) throws IOException {
        this(ResourcePropertySource.getResourceForLocation(location2, classLoader));
    }

    public ResourcePropertySource(String location2) throws IOException {
        this(ResourcePropertySource.getResourceForLocation(location2, ClassUtils.getDefaultClassLoader()));
    }

    private static Resource getResourceForLocation(String location2, ClassLoader classLoader) {
        return new PathMatchingResourcePatternResolver(classLoader).getResource(location2);
    }

    private static Properties loadPropertiesForResource(Resource resource) throws IOException {
        Properties props = new Properties();
        InputStream is2 = resource.getInputStream();
        props.load(is2);
        try {
            is2.close();
        }
        catch (IOException iOException) {}
        return props;
    }

    private static String getNameForResource(Resource resource) {
        String name = resource.getDescription();
        if (!StringUtils.hasText(name)) {
            name = String.valueOf(resource.getClass().getSimpleName()) + "@" + System.identityHashCode(resource);
        }
        return name;
    }
}

