/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.style.ValueStyler;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[empty]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String ARRAY = "array";

    public String style(Object value2) {
        if (value2 == null) {
            return NULL;
        }
        if (value2 instanceof String) {
            return "'" + value2 + "'";
        }
        if (value2 instanceof Class) {
            return ClassUtils.getShortName((Class)value2);
        }
        if (value2 instanceof Method) {
            Method method = (Method)value2;
            return String.valueOf(method.getName()) + "@" + ClassUtils.getShortName(method.getDeclaringClass());
        }
        if (value2 instanceof Map) {
            return this.style((Map)value2);
        }
        if (value2 instanceof Map.Entry) {
            return this.style((Map.Entry)value2);
        }
        if (value2 instanceof Collection) {
            return this.style((Collection)value2);
        }
        if (value2.getClass().isArray()) {
            return this.styleArray(ObjectUtils.toObjectArray(value2));
        }
        return String.valueOf(value2);
    }

    private String style(Map value2) {
        StringBuilder result2 = new StringBuilder(value2.size() * 8 + 16);
        result2.append("map[");
        Iterator it = value2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            result2.append(this.style(entry2));
            if (!it.hasNext()) continue;
            result2.append(',').append(' ');
        }
        if (value2.isEmpty()) {
            result2.append(EMPTY);
        }
        result2.append("]");
        return result2.toString();
    }

    private String style(Map.Entry value2) {
        return String.valueOf(this.style(value2.getKey())) + " -> " + this.style(value2.getValue());
    }

    private String style(Collection value2) {
        StringBuilder result2 = new StringBuilder(value2.size() * 8 + 16);
        result2.append(this.getCollectionTypeString(value2)).append('[');
        Iterator i = value2.iterator();
        while (i.hasNext()) {
            result2.append(this.style(i.next()));
            if (!i.hasNext()) continue;
            result2.append(',').append(' ');
        }
        if (value2.isEmpty()) {
            result2.append(EMPTY);
        }
        result2.append("]");
        return result2.toString();
    }

    private String getCollectionTypeString(Collection value2) {
        if (value2 instanceof List) {
            return LIST;
        }
        if (value2 instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }

    private String styleArray(Object[] array2) {
        StringBuilder result2 = new StringBuilder(array2.length * 8 + 16);
        result2.append("array<").append(ClassUtils.getShortName(array2.getClass().getComponentType())).append(">[");
        int i = 0;
        while (i < array2.length - 1) {
            result2.append(this.style(array2[i]));
            result2.append(',').append(' ');
            ++i;
        }
        if (array2.length > 0) {
            result2.append(this.style(array2[array2.length - 1]));
        } else {
            result2.append(EMPTY);
        }
        result2.append("]");
        return result2.toString();
    }
}

