/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.classreading.RecursiveAnnotationArrayVisitor;
import org.springframework.core.type.classreading.RecursiveAnnotationAttributesVisitor;
import org.springframework.util.ReflectionUtils;

abstract class AbstractRecursiveAnnotationVisitor
implements AnnotationVisitor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AnnotationAttributes attributes;
    protected final ClassLoader classLoader;

    public AbstractRecursiveAnnotationVisitor(ClassLoader classLoader, AnnotationAttributes attributes2) {
        this.classLoader = classLoader;
        this.attributes = attributes2;
    }

    public void visit(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public AnnotationVisitor visitAnnotation(String attributeName, String asmTypeDescriptor) {
        String annotationType = Type.getType(asmTypeDescriptor).getClassName();
        AnnotationAttributes nestedAttributes = new AnnotationAttributes();
        this.attributes.put(attributeName, nestedAttributes);
        return new RecursiveAnnotationAttributesVisitor(annotationType, nestedAttributes, this.classLoader);
    }

    public AnnotationVisitor visitArray(String attributeName) {
        return new RecursiveAnnotationArrayVisitor(attributeName, this.attributes, this.classLoader);
    }

    public void visitEnum(String attributeName, String asmTypeDescriptor, String attributeValue) {
        Object valueToUse = attributeValue;
        try {
            Class<?> enumType = this.classLoader.loadClass(Type.getType(asmTypeDescriptor).getClassName());
            Field enumConstant = ReflectionUtils.findField(enumType, attributeValue);
            if (enumConstant != null) {
                valueToUse = enumConstant.get(null);
            }
        }
        catch (Exception ex2) {
            this.logNonFatalException(ex2);
        }
        this.attributes.put(attributeName, valueToUse);
    }

    protected void logNonFatalException(Exception ex2) {
        this.logger.warn("Failed to classload type while reading annotation metadata. This is a non-fatal error, but certain annotation metadata may be unavailable.", ex2);
    }
}

