/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.interceptor;

import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJBException;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

public class SpringBeanAutowiringInterceptor {
    private final Map<Object, BeanFactoryReference> beanFactoryReferences = new WeakHashMap<Object, BeanFactoryReference>();

    @PostConstruct
    @PostActivate
    public void autowireBean(InvocationContext invocationContext) {
        this.doAutowireBean(invocationContext.getTarget());
        try {
            invocationContext.proceed();
        }
        catch (RuntimeException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new EJBException(ex3);
        }
    }

    protected void doAutowireBean(Object target2) {
        AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
        this.configureBeanPostProcessor(bpp, target2);
        bpp.setBeanFactory(this.getBeanFactory(target2));
        bpp.processInjection(target2);
    }

    protected void configureBeanPostProcessor(AutowiredAnnotationBeanPostProcessor processor, Object target2) {
    }

    protected BeanFactory getBeanFactory(Object target2) {
        BeanFactory factory = this.getBeanFactoryReference(target2).getFactory();
        if (factory instanceof ApplicationContext) {
            factory = ((ApplicationContext)factory).getAutowireCapableBeanFactory();
        }
        return factory;
    }

    protected BeanFactoryReference getBeanFactoryReference(Object target2) {
        String key = this.getBeanFactoryLocatorKey(target2);
        BeanFactoryReference ref = this.getBeanFactoryLocator(target2).useBeanFactory(key);
        this.beanFactoryReferences.put(target2, ref);
        return ref;
    }

    protected BeanFactoryLocator getBeanFactoryLocator(Object target2) {
        return ContextSingletonBeanFactoryLocator.getInstance();
    }

    protected String getBeanFactoryLocatorKey(Object target2) {
        return null;
    }

    @PreDestroy
    @PrePassivate
    public void releaseBean(InvocationContext invocationContext) {
        this.doReleaseBean(invocationContext.getTarget());
        try {
            invocationContext.proceed();
        }
        catch (RuntimeException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new EJBException(ex3);
        }
    }

    protected void doReleaseBean(Object target2) {
        BeanFactoryReference ref = this.beanFactoryReferences.remove(target2);
        if (ref != null) {
            ref.release();
        }
    }
}

