/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel;

import org.springframework.expression.ParseException;
import org.springframework.expression.spel.SpelMessage;

public class SpelParseException
extends ParseException {
    private SpelMessage message;
    private Object[] inserts;

    public SpelParseException(String expressionString, int position2, SpelMessage message, Object ... inserts) {
        super(expressionString, position2, message.formatMessage(position2, inserts));
        this.position = position2;
        this.message = message;
        this.inserts = inserts;
    }

    public SpelParseException(int position2, SpelMessage message, Object ... inserts) {
        super(position2, message.formatMessage(position2, inserts));
        this.position = position2;
        this.message = message;
        this.inserts = inserts;
    }

    public SpelParseException(int position2, Throwable cause, SpelMessage message, Object ... inserts) {
        super(position2, message.formatMessage(position2, inserts), cause);
        this.position = position2;
        this.message = message;
        this.inserts = inserts;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message.formatMessage(this.position, this.inserts);
        }
        return super.getMessage();
    }

    public SpelMessage getMessageCode() {
        return this.message;
    }

    public Object[] getInserts() {
        return this.inserts;
    }
}

