/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class CompoundExpression
extends SpelNodeImpl {
    public CompoundExpression(int pos, SpelNodeImpl ... expressionComponents) {
        super(pos, expressionComponents);
        if (expressionComponents.length < 2) {
            throw new IllegalStateException("Dont build compound expression less than one entry: " + expressionComponents.length);
        }
    }

    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue result2 = null;
        SpelNodeImpl nextNode = null;
        try {
            nextNode = this.children[0];
            result2 = nextNode.getValueInternal(state2);
            int i = 1;
            while (i < this.getChildCount()) {
                try {
                    state2.pushActiveContextObject(result2);
                    nextNode = this.children[i];
                    result2 = nextNode.getValueInternal(state2);
                }
                finally {
                    state2.popActiveContextObject();
                }
                ++i;
            }
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(nextNode.getStartPosition());
            throw ee;
        }
        return result2;
    }

    public void setValue(ExpressionState state2, Object value2) throws EvaluationException {
        if (this.getChildCount() == 1) {
            this.getChild(0).setValue(state2, value2);
            return;
        }
        TypedValue ctx = this.children[0].getValueInternal(state2);
        int i = 1;
        while (i < this.getChildCount() - 1) {
            try {
                state2.pushActiveContextObject(ctx);
                ctx = this.children[i].getValueInternal(state2);
            }
            finally {
                state2.popActiveContextObject();
            }
            ++i;
        }
        try {
            state2.pushActiveContextObject(ctx);
            this.getChild(this.getChildCount() - 1).setValue(state2, value2);
        }
        finally {
            state2.popActiveContextObject();
        }
    }

    public boolean isWritable(ExpressionState state2) throws EvaluationException {
        if (this.getChildCount() == 1) {
            return this.getChild(0).isWritable(state2);
        }
        TypedValue ctx = this.children[0].getValueInternal(state2);
        int i = 1;
        while (i < this.getChildCount() - 1) {
            try {
                state2.pushActiveContextObject(ctx);
                ctx = this.children[i].getValueInternal(state2);
            }
            finally {
                state2.popActiveContextObject();
            }
            ++i;
        }
        try {
            state2.pushActiveContextObject(ctx);
            boolean bl = this.getChild(this.getChildCount() - 1).isWritable(state2);
            return bl;
        }
        finally {
            state2.popActiveContextObject();
        }
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        return sb.toString();
    }
}

