/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.List;
import org.springframework.core.convert.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatHelper {
    public static String formatMethodForMessage(String name, List<TypeDescriptor> argumentTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        int i = 0;
        while (i < argumentTypes.size()) {
            TypeDescriptor typeDescriptor;
            if (i > 0) {
                sb.append(",");
            }
            if ((typeDescriptor = argumentTypes.get(i)) != null) {
                sb.append(FormatHelper.formatClassNameForMessage(typeDescriptor.getType()));
            } else {
                sb.append(FormatHelper.formatClassNameForMessage(null));
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String formatClassNameForMessage(Class<?> clazz2) {
        if (clazz2 == null) {
            return "null";
        }
        StringBuilder fmtd = new StringBuilder();
        if (clazz2.isArray()) {
            int dims = 1;
            Class<?> baseClass = clazz2.getComponentType();
            while (baseClass.isArray()) {
                baseClass = baseClass.getComponentType();
                ++dims;
            }
            fmtd.append(baseClass.getName());
            int i = 0;
            while (i < dims) {
                fmtd.append("[]");
                ++i;
            }
        } else {
            fmtd.append(clazz2.getName());
        }
        return fmtd.toString();
    }
}

